/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.CatchEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TryEvaluator
implements Evaluator {
    @NotNull
    private final Evaluator myBodyEvaluator;
    private final List<CatchEvaluator> myCatchBlockEvaluators;
    @Nullable
    private final Evaluator myFinallyEvaluator;

    public TryEvaluator(@NotNull Evaluator bodyEvaluator, List<CatchEvaluator> catchBlockEvaluators, @Nullable Evaluator finallyEvaluator) {
        if (bodyEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyEvaluator", "com/intellij/debugger/engine/evaluation/expression/TryEvaluator", "<init>"));
        }
        this.myBodyEvaluator = bodyEvaluator;
        this.myCatchBlockEvaluators = catchBlockEvaluators;
        this.myFinallyEvaluator = finallyEvaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object result2 = context.getSuspendContext().getDebugProcess().getVirtualMachineProxy().mirrorOfVoid();
        try {
            result2 = this.myBodyEvaluator.evaluate(context);
        }
        catch (EvaluateException e) {
            boolean catched = false;
            ObjectReference vmException = e.getExceptionFromTargetVM();
            if (vmException != null) {
                for (CatchEvaluator evaluator : this.myCatchBlockEvaluators) {
                    if (evaluator == null || !DebuggerUtils.instanceOf((Type)vmException.type(), (String)evaluator.getExceptionType())) continue;
                    result2 = evaluator.evaluate(vmException, context);
                    catched = true;
                    break;
                }
            }
            if (!catched) {
                throw e;
            }
        }
        finally {
            if (this.myFinallyEvaluator != null) {
                result2 = this.myFinallyEvaluator.evaluate(context);
            }
        }
        return result2;
    }
}

