/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;

public class StackFrameData
extends DescriptorData<StackFrameDescriptorImpl> {
    private final StackFrameProxyImpl myFrame;
    private final FrameDisplayKey myDisplayKey;
    private final MethodsTracker myMethodsTracker;

    public StackFrameData(@NotNull StackFrameProxyImpl frame) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/impl/descriptors/data/StackFrameData", "<init>"));
        }
        this.myFrame = frame;
        this.myDisplayKey = new FrameDisplayKey(NodeManagerImpl.getContextKeyForFrame(frame));
        this.myMethodsTracker = new MethodsTracker();
    }

    @Override
    protected StackFrameDescriptorImpl createDescriptorImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/impl/descriptors/data/StackFrameData", "createDescriptorImpl"));
        }
        return new StackFrameDescriptorImpl(this.myFrame, this.myMethodsTracker);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof StackFrameData)) {
            return false;
        }
        return ((StackFrameData)object).myFrame == this.myFrame;
    }

    @Override
    public int hashCode() {
        return this.myFrame.hashCode();
    }

    @Override
    public DisplayKey<StackFrameDescriptorImpl> getDisplayKey() {
        return this.myDisplayKey;
    }

    private static class FrameDisplayKey
    implements DisplayKey<StackFrameDescriptorImpl> {
        private final String myContextKey;

        public FrameDisplayKey(String contextKey) {
            this.myContextKey = contextKey;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FrameDisplayKey that = (FrameDisplayKey)o;
            return Comparing.equal((String)this.myContextKey, (String)that.myContextKey);
        }

        @Override
        public int hashCode() {
            return this.myContextKey == null ? 0 : this.myContextKey.hashCode();
        }
    }
}

