/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.memory.filtering.CheckingResult;
import org.jetbrains.annotations.NotNull;

public class CheckingResultImpl
implements CheckingResult {
    public static final CheckingResult SUCCESS = new CheckingResultImpl(CheckingResult.Result.MATCH, "");
    public static final CheckingResult FAIL = new CheckingResultImpl(CheckingResult.Result.NO_MATCH, "");
    private final CheckingResult.Result myResult;
    private final String myDescription;

    private CheckingResultImpl(@NotNull CheckingResult.Result result2, @NotNull String description) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/debugger/memory/filtering/CheckingResultImpl", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/debugger/memory/filtering/CheckingResultImpl", "<init>"));
        }
        this.myResult = result2;
        this.myDescription = description;
    }

    public static CheckingResult error(@NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/debugger/memory/filtering/CheckingResultImpl", "error"));
        }
        return new CheckingResultImpl(CheckingResult.Result.ERROR, description);
    }

    @Override
    @NotNull
    public CheckingResult.Result getResult() {
        CheckingResult.Result result2 = this.myResult;
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/filtering/CheckingResultImpl", "getResult"));
        }
        return result2;
    }

    @Override
    @NotNull
    public String getFailureDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/filtering/CheckingResultImpl", "getFailureDescription"));
        }
        return string;
    }
}

