/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.filtering.CheckingResult;
import com.intellij.debugger.memory.filtering.ConditionChecker;
import com.intellij.debugger.memory.filtering.ConditionCheckerImpl;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XExpression;
import com.sun.jdi.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FilteringTask
implements Runnable {
    private final List<ObjectReference> myReferences;
    private final ConditionChecker myChecker;
    private final FilteringTaskCallback myCallback;
    private volatile boolean myIsCancelled;

    public FilteringTask(@NotNull String className, @NotNull DebugProcessImpl debugProcess, @NotNull XExpression expression, @NotNull List<ObjectReference> references, @NotNull FilteringTaskCallback callback) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/memory/filtering/FilteringTask", "<init>"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/memory/filtering/FilteringTask", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/memory/filtering/FilteringTask", "<init>"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/debugger/memory/filtering/FilteringTask", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/memory/filtering/FilteringTask", "<init>"));
        }
        this.myIsCancelled = false;
        this.myChecker = StringUtil.isEmptyOrSpaces((String)expression.getExpression()) ? ConditionChecker.ALL_MATCHED_CHECKER : new ConditionCheckerImpl(debugProcess, expression, className);
        this.myReferences = references;
        this.myCallback = callback;
    }

    public void cancel() {
        this.myIsCancelled = true;
    }

    public boolean isCancelled() {
        return this.myIsCancelled;
    }

    @Override
    public void run() {
        int proceedCount;
        this.myCallback.started(this.myReferences.size());
        for (proceedCount = 0; proceedCount < this.myReferences.size() && !this.myIsCancelled; ++proceedCount) {
            ObjectReference ref = this.myReferences.get(proceedCount);
            CheckingResult result2 = this.myChecker.check(ref);
            FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
            switch (result2.getResult()) {
                case MATCH: {
                    action = this.myCallback.matched(ref);
                    break;
                }
                case NO_MATCH: {
                    action = this.myCallback.notMatched(ref);
                    break;
                }
                case ERROR: {
                    action = this.myCallback.error(ref, result2.getFailureDescription());
                }
            }
            if (action == FilteringTaskCallback.Action.STOP) break;
        }
        FilteringResult reason = this.myIsCancelled ? FilteringResult.INTERRUPTED : (proceedCount == this.myReferences.size() ? FilteringResult.ALL_CHECKED : FilteringResult.LIMIT_REACHED);
        this.myCallback.completed(reason);
    }
}

