/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.sun.jdi.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MethodsTracker {
    private final Map<Method, Integer> myMethodToOccurrenceMap = new HashMap<Method, Integer>();
    private final Map<Integer, Integer> myInitialOccurence = new HashMap<Integer, Integer>();

    public MethodOccurrence getMethodOccurrence(int frameIndex, @Nullable Method method2) {
        Integer initial = this.myInitialOccurence.get(frameIndex);
        if (initial == null) {
            initial = this.getOccurrenceCount(method2);
            this.myMethodToOccurrenceMap.put(method2, initial + 1);
            this.myInitialOccurence.put(frameIndex, initial);
        }
        return new MethodOccurrence(method2, initial);
    }

    private int getOccurrenceCount(Method method2) {
        if (method2 == null) {
            return 0;
        }
        Integer integer = this.myMethodToOccurrenceMap.get(method2);
        return integer != null ? integer : 0;
    }

    public final class MethodOccurrence {
        private final Method myMethod;
        private final int myIndex;

        private MethodOccurrence(Method method2, int index) {
            this.myMethod = method2;
            this.myIndex = index;
        }

        public Method getMethod() {
            return this.myMethod;
        }

        public int getIndex() {
            return MethodsTracker.this.getOccurrenceCount(this.myMethod) - this.myIndex;
        }

        public boolean isRecursive() {
            return MethodsTracker.this.getOccurrenceCount(this.myMethod) > 1;
        }
    }
}

