/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.nodes.NodeComparator;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.DefaultNodeDescriptor;
import com.intellij.debugger.ui.impl.watch.DescriptorTree;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorFactoryImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class NodeManagerImpl
extends NodeDescriptorFactoryImpl
implements NodeManager {
    private static final Comparator<DebuggerTreeNode> ourNodeComparator = new NodeComparator();
    private final DebuggerTree myDebuggerTree;
    private String myHistoryKey = null;
    private final Map<String, DescriptorTree> myHistories = new HashMap();

    public NodeManagerImpl(Project project2, DebuggerTree tree) {
        super(project2);
        this.myDebuggerTree = tree;
    }

    public static Comparator<DebuggerTreeNode> getNodeComparator() {
        return ourNodeComparator;
    }

    @Override
    public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor, EvaluationContext evaluationContext) {
        ((NodeDescriptorImpl)descriptor).setContext((EvaluationContextImpl)evaluationContext);
        return DebuggerTreeNodeImpl.createNode(this.getTree(), (NodeDescriptorImpl)descriptor, (EvaluationContextImpl)evaluationContext);
    }

    public DebuggerTreeNodeImpl getDefaultNode() {
        return DebuggerTreeNodeImpl.createNodeNoUpdate(this.getTree(), new DefaultNodeDescriptor());
    }

    public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor) {
        return DebuggerTreeNodeImpl.createNodeNoUpdate(this.getTree(), descriptor);
    }

    @Override
    public DebuggerTreeNodeImpl createMessageNode(String message) {
        return DebuggerTreeNodeImpl.createNodeNoUpdate(this.getTree(), new MessageDescriptor(message));
    }

    public void setHistoryByContext(DebuggerContextImpl context) {
        this.setHistoryByContext(context.getFrameProxy());
    }

    public void setHistoryByContext(StackFrameProxyImpl frameProxy) {
        DescriptorTree historyTree;
        String historyKey;
        if (this.myHistoryKey != null) {
            this.myHistories.put(this.myHistoryKey, this.getCurrentHistoryTree());
        }
        DescriptorTree descriptorTree = (historyKey = this.getContextKey(frameProxy)) != null ? ((historyTree = this.myHistories.get(historyKey)) != null ? historyTree : new DescriptorTree(true)) : new DescriptorTree(true);
        this.deriveHistoryTree(descriptorTree, frameProxy);
        this.myHistoryKey = historyKey;
    }

    @Nullable
    public String getContextKey(StackFrameProxyImpl frame) {
        return NodeManagerImpl.getContextKeyForFrame(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getContextKeyForFrame(StackFrameProxyImpl frame) {
        block8: {
            String string;
            if (frame == null) {
                return null;
            }
            Location location2 = frame.location();
            Method method2 = DebuggerUtilsEx.getMethod(location2);
            if (method2 == null) {
                return null;
            }
            ReferenceType referenceType = location2.declaringType();
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                string = builder.append(referenceType.signature()).append("#").append(method2.name()).append(method2.signature()).toString();
            }
            catch (Throwable throwable) {
                try {
                    StringBuilderSpinAllocator.dispose((StringBuilder)builder);
                    throw throwable;
                }
                catch (EvaluateException location2) {
                    break block8;
                }
                catch (InternalException ie) {
                    if (ie.errorCode() == 23) break block8;
                    throw ie;
                }
            }
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            return string;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.clearHistory();
        super.dispose();
    }

    public void clearHistory() {
        this.myHistories.clear();
    }

    private DebuggerTree getTree() {
        return this.myDebuggerTree;
    }
}

