/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class BinaryRenderer
extends NodeRendererImpl {
    private static final Logger LOG = Logger.getInstance(BinaryRenderer.class);

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        Value value = valueDescriptor.getValue();
        if (value == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder("0b");
        int prefixLength = buf.length();
        if (value instanceof ByteValue) {
            buf.append(Integer.toBinaryString(0xFF & ((ByteValue)value).byteValue()));
        } else if (value instanceof ShortValue) {
            buf.append(Integer.toBinaryString(0xFFFF & ((ShortValue)value).shortValue()));
        } else if (value instanceof IntegerValue) {
            buf.append(Integer.toBinaryString(((PrimitiveValue)value).intValue()));
        } else if (value instanceof LongValue) {
            buf.append(Long.toBinaryString(((LongValue)value).longValue()));
        } else {
            LOG.error("Unsupported value " + value);
        }
        for (int i2 = buf.length() - 8; i2 > prefixLength; i2 -= 8) {
            buf.insert(i2, '_');
        }
        return buf.toString();
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return null;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return false;
    }

    @Override
    public String getName() {
        return "Binary";
    }

    @Override
    public String getUniqueId() {
        return "BinaryRenderer";
    }

    @Override
    public boolean isApplicable(Type t) {
        if (t == null) {
            return false;
        }
        return t instanceof ByteType || t instanceof ShortType || t instanceof IntegerType || t instanceof LongType;
    }
}

