/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.UserExpressionDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.Type;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFieldInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final UserExpressionDescriptorImpl myDescriptor;
    protected final EnumerationChildrenRenderer myRenderer;

    public CustomFieldInplaceEditor(@NotNull XDebuggerTreeNode node, @Nullable UserExpressionDescriptorImpl descriptor, @Nullable EnumerationChildrenRenderer renderer) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/ui/tree/render/CustomFieldInplaceEditor", "<init>"));
        }
        super(node, "customField");
        this.myDescriptor = descriptor;
        this.myRenderer = renderer;
        this.myExpressionEditor.setExpression(descriptor != null ? TextWithImportsImpl.toXExpression(descriptor.getEvaluationText()) : null);
        ValueDescriptorImpl parentDescriptor = ((JavaValue)((XValueContainerNode)node.getParent()).getValueContainer()).getDescriptor();
        Pair<PsiElement, PsiType> pair = DebuggerUtilsImpl.getPsiClassAndType(CustomFieldInplaceEditor.getTypeName(parentDescriptor), this.getProject());
        if (pair.first != null) {
            this.myExpressionEditor.setContext((PsiElement)pair.first);
        }
    }

    public static void editNew(final @NotNull XValueNodeImpl parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/debugger/ui/tree/render/CustomFieldInplaceEditor", "editNew"));
        }
        final ValueDescriptorImpl descriptor = ((JavaValue)parentNode.getValueContainer()).getDescriptor();
        EnumerationChildrenRenderer renderer = EnumerationChildrenRenderer.getCurrent(descriptor);
        final XDebuggerTreeNode newNode = parentNode.addTemporaryEditorNode();
        DebuggerUIUtil.invokeLater(() -> {
            if (parentNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/debugger/ui/tree/render/CustomFieldInplaceEditor", "lambda$editNew$0"));
            }
            new CustomFieldInplaceEditor(newNode, null, renderer){

                @Override
                public void cancelEditing() {
                    super.cancelEditing();
                    parentNode.removeTemporaryEditorNode(newNode);
                }

                @Override
                protected List<Pair<String, TextWithImports>> getRendererChildren() {
                    if (this.myRenderer != null) {
                        return this.myRenderer.getChildren();
                    }
                    String name = CustomFieldInplaceEditor.getTypeName(descriptor);
                    EnumerationChildrenRenderer enumerationChildrenRenderer = new EnumerationChildrenRenderer();
                    enumerationChildrenRenderer.setAppendDefaultChildren(true);
                    Renderer lastRenderer = descriptor.getLastRenderer();
                    if (lastRenderer instanceof CompoundNodeRenderer && NodeRendererSettings.getInstance().getCustomRenderers().contains((NodeRenderer)lastRenderer) && !(((CompoundNodeRenderer)lastRenderer).getChildrenRenderer() instanceof ExpressionChildrenRenderer)) {
                        ((CompoundNodeRenderer)lastRenderer).setChildrenRenderer(enumerationChildrenRenderer);
                    } else {
                        CompoundTypeRenderer renderer = NodeRendererSettings.getInstance().createCompoundTypeRenderer(name, name, null, enumerationChildrenRenderer);
                        renderer.setEnabled(true);
                        NodeRendererSettings.getInstance().getCustomRenderers().addRenderer(renderer);
                        NodeRendererSettings.getInstance().fireRenderersChanged();
                    }
                    return enumerationChildrenRenderer.getChildren();
                }
            }.show();
        });
    }

    @Nullable
    private static String getTypeName(ValueDescriptorImpl descriptor) {
        Type type = descriptor.getType();
        return type != null ? type.name() : null;
    }

    protected List<Pair<String, TextWithImports>> getRendererChildren() {
        return this.myRenderer.getChildren();
    }

    @Override
    public void doOKAction() {
        List<Pair<String, TextWithImports>> children2 = this.getRendererChildren();
        TextWithImports newText = TextWithImportsImpl.fromXExpression(this.myExpressionEditor.getExpression());
        if (this.myDescriptor == null) {
            children2.add(0, (Pair<String, TextWithImports>)Pair.create((Object)"", (Object)newText));
        } else {
            int index = this.myDescriptor.getEnumerationIndex();
            children2.set(index, (Pair<String, TextWithImports>)Pair.create((Object)children2.get((int)index).first, (Object)newText));
        }
        this.myTree.putClientProperty("selection.path", CustomFieldInplaceEditor.createDummySelectionTreePath(newText.getText(), (XDebuggerTreeNode)this.myNode.getParent()));
        XDebuggerUtilImpl.rebuildTreeAndViews(this.myTree);
        super.doOKAction();
    }

    private static TreePath createDummySelectionTreePath(String name, XDebuggerTreeNode parentNode) {
        return new XValueNodeImpl(parentNode.getTree(), parentNode, name, new XValue(){

            public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/ui/tree/render/CustomFieldInplaceEditor$2", "computePresentation"));
                }
                if (place == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/debugger/ui/tree/render/CustomFieldInplaceEditor$2", "computePresentation"));
                }
            }
        }).getPath();
    }
}

