/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.actions;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.designer.propertyTable.actions.IPropertyTableAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;

public class ShowJavadoc
extends AnAction
implements IPropertyTableAction {
    private final RadPropertyTable myTable;

    public ShowJavadoc(RadPropertyTable table) {
        this.myTable = table;
        Presentation presentation = this.getTemplatePresentation();
        String text = DesignerBundle.message("designer.properties.show.javadoc", new Object[0]);
        presentation.setText(text);
        presentation.setDescription(text);
        presentation.setIcon(AllIcons.Actions.Help);
    }

    public void update(AnActionEvent e) {
        ShowJavadoc.setEnabled(this.myTable, e, e.getPresentation());
    }

    @Override
    public void update() {
        ShowJavadoc.setEnabled(this.myTable, null, this.getTemplatePresentation());
    }

    private static void setEnabled(RadPropertyTable table, AnActionEvent e, Presentation presentation) {
        Property property = table.getSelectionProperty();
        presentation.setEnabled(!(property == null || table.isEditing() || property.getJavadocElement() == null && StringUtil.isEmpty((String)property.getJavadocText()) || e != null && e.getProject() == null));
    }

    public void actionPerformed(AnActionEvent e) {
        ActionCallback callback;
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        DocumentationManager documentationManager = DocumentationManager.getInstance(project2);
        DocumentationComponent component = new DocumentationComponent(documentationManager);
        Property property = this.myTable.getSelectionProperty();
        if (property == null) {
            return;
        }
        PsiElement javadocElement = property.getJavadocElement();
        if (javadocElement == null) {
            callback = new ActionCallback();
            component.setText(property.getJavadocText(), null, true);
        } else {
            callback = documentationManager.queueFetchDocInfo(javadocElement, component);
        }
        callback.doWhenProcessed(() -> {
            JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, (JComponent)component).setProject(project2).setDimensionServiceKey(project2, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(DesignerBundle.message("designer.properties.javadoc.title", property.getName())).setCancelCallback(() -> {
                Disposer.dispose((Disposable)component);
                return Boolean.TRUE;
            }).createPopup();
            component.setHint(hint);
            Disposer.register((Disposable)hint, (Disposable)component);
            hint.show(new RelativePoint((Component)this.myTable.getParent(), new Point(0, 0)));
        });
        if (javadocElement == null) {
            callback.setDone();
        }
    }
}

