/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.ApplicationStarterBase;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeApplication
extends ApplicationStarterBase {
    @Override
    protected boolean checkArguments(@NotNull String[] args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/diff/applications/MergeApplication", "checkArguments"));
        }
        return (args.length == 4 || args.length == 5) && "merge".equals(args[0]);
    }

    public String getCommandName() {
        return "merge";
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        String string = DiffBundle.message((String)"merge.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/applications/MergeApplication", "getUsageMessage"));
        }
        return string;
    }

    @Override
    public void processCommand(@NotNull String[] args, @Nullable String currentDirectory) throws Exception {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/diff/applications/MergeApplication", "processCommand"));
        }
        Project project2 = this.getProject();
        List<String> filePaths = Arrays.asList(args).subList(1, args.length);
        List<VirtualFile> files = MergeApplication.findFiles(filePaths, currentDirectory);
        List contents = ContainerUtil.list((Object[])new VirtualFile[]{files.get(0), files.get(2), files.get(1)});
        VirtualFile outputFile = files.get(files.size() - 1);
        MergeRequest request = DiffRequestFactory.getInstance().createMergeRequestFromFiles(project2, outputFile, contents, null);
        DiffManagerEx.getInstance().showMergeBuiltin(project2, request);
        Document document = FileDocumentManager.getInstance().getCachedDocument(outputFile);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
    }
}

