/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.DiffViewerListener;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.Navigatable;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffViewerBase
implements FrameDiffTool.DiffViewer,
DataProvider {
    protected static final Logger LOG = Logger.getInstance(DiffViewerBase.class);
    @NotNull
    private final List<DiffViewerListener> myListeners;
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    protected final ContentDiffRequest myRequest;
    @NotNull
    private final DiffTaskQueue myTaskExecutor;
    @NotNull
    private final Alarm myTaskAlarm;
    private volatile boolean myDisposed;

    public DiffViewerBase(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/DiffViewerBase", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/DiffViewerBase", "<init>"));
        }
        this.myListeners = new SmartList();
        this.myTaskExecutor = new DiffTaskQueue();
        this.myTaskAlarm = new Alarm();
        this.myProject = context.getProject();
        this.myContext = context;
        this.myRequest = request;
    }

    @NotNull
    public final FrameDiffTool.ToolbarComponents init() {
        this.processContextHints();
        this.onInit();
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = this.createToolbarActions();
        components.popupActions = this.createPopupActions();
        components.statusPanel = this.getStatusPanel();
        this.fireEvent(EventType.INIT);
        this.rediff(true);
        FrameDiffTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffViewerBase", "init"));
        }
        return toolbarComponents;
    }

    public final void dispose() {
        if (this.myDisposed) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            LOG.warn(new Throwable("dispose() not from EDT"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.abortRediff();
            this.updateContextHints();
            this.fireEvent(EventType.DISPOSE);
            this.onDispose();
        });
    }

    protected void processContextHints() {
    }

    protected void updateContextHints() {
    }

    public final void scheduleRediff() {
        if (this.isDisposed()) {
            return;
        }
        this.abortRediff();
        this.myTaskAlarm.addRequest(this::rediff, 300);
    }

    public final void abortRediff() {
        this.myTaskExecutor.abort();
        this.myTaskAlarm.cancelAllRequests();
        this.fireEvent(EventType.REDIFF_ABORTED);
    }

    public final void rediff() {
        this.rediff(false);
    }

    public void rediff(boolean trySync) {
        if (this.isDisposed()) {
            return;
        }
        this.abortRediff();
        this.fireEvent(EventType.BEFORE_REDIFF);
        this.onBeforeRediff();
        boolean forceEDT = this.forceRediffSynchronously();
        int waitMillis = trySync || this.tryRediffSynchronously() ? 300 : 0;
        this.myTaskExecutor.executeAndTryWait((Function<ProgressIndicator, Runnable>)((Function)indicator -> {
            Runnable callback = this.performRediff((ProgressIndicator)indicator);
            return () -> {
                callback.run();
                this.onAfterRediff();
                this.fireEvent(EventType.AFTER_REDIFF);
            };
        }), this::onSlowRediff, waitMillis, forceEDT);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public ContentDiffRequest getRequest() {
        ContentDiffRequest contentDiffRequest = this.myRequest;
        if (contentDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffViewerBase", "getRequest"));
        }
        return contentDiffRequest;
    }

    @NotNull
    public DiffContext getContext() {
        DiffContext diffContext = this.myContext;
        if (diffContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffViewerBase", "getContext"));
        }
        return diffContext;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    protected boolean tryRediffSynchronously() {
        return this.myContext.isWindowFocused();
    }

    protected boolean forceRediffSynchronously() {
        return ApplicationManager.getApplication().isWriteAccessAllowed();
    }

    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        ContainerUtil.addAll(group, (Object[])((ActionGroup)ActionManager.getInstance().getAction("Diff.ViewerToolbar")).getChildren(null));
        return group;
    }

    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        ContainerUtil.addAll(group, (Object[])((ActionGroup)ActionManager.getInstance().getAction("Diff.ViewerPopupMenu")).getChildren(null));
        return group;
    }

    @Nullable
    protected JComponent getStatusPanel() {
        return null;
    }

    protected void onInit() {
    }

    protected void onSlowRediff() {
    }

    protected void onBeforeRediff() {
    }

    protected void onAfterRediff() {
    }

    @NotNull
    protected abstract Runnable performRediff(@NotNull ProgressIndicator var1);

    protected void onDispose() {
        Disposer.dispose((Disposable)this.myTaskAlarm);
    }

    @Nullable
    protected Navigatable getNavigatable() {
        return null;
    }

    public void addListener(@NotNull DiffViewerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/diff/tools/util/base/DiffViewerBase", "addListener"));
        }
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull DiffViewerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/diff/tools/util/base/DiffViewerBase", "removeListener"));
        }
        this.myListeners.remove(listener2);
    }

    @NotNull
    protected List<DiffViewerListener> getListeners() {
        List<DiffViewerListener> list = this.myListeners;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffViewerBase", "getListeners"));
        }
        return list;
    }

    private void fireEvent(@NotNull EventType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/util/base/DiffViewerBase", "fireEvent"));
        }
        for (DiffViewerListener listener2 : this.myListeners) {
            switch (type) {
                case INIT: {
                    listener2.onInit();
                    break;
                }
                case DISPOSE: {
                    listener2.onDispose();
                    break;
                }
                case BEFORE_REDIFF: {
                    listener2.onBeforeRediff();
                    break;
                }
                case AFTER_REDIFF: {
                    listener2.onAfterRediff();
                    break;
                }
                case REDIFF_ABORTED: {
                    listener2.onRediffAborted();
                }
            }
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getNavigatable();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    private static enum EventType {
        INIT,
        DISPOSE,
        BEFORE_REDIFF,
        AFTER_REDIFF,
        REDIFF_ABORTED;

    }
}

