/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TextDiffViewerUtil {
    private static final Logger LOG = Logger.getInstance(TextDiffViewerUtil.class);

    @NotNull
    public static List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add(ActionManager.getInstance().getAction("CompareClipboardWithSelection"));
        result2.add((AnAction)Separator.getInstance());
        ContainerUtil.addAll(result2, (Object[])((ActionGroup)ActionManager.getInstance().getAction("Diff.EditorPopupMenu")).getChildren(null));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "createEditorPopupActions"));
        }
        return arrayList;
    }

    @NotNull
    public static FoldingModelSupport.Settings getFoldingModelSettings(@NotNull DiffContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getFoldingModelSettings"));
        }
        TextDiffSettingsHolder.TextDiffSettings settings = TextDiffViewerUtil.getTextSettings(context);
        FoldingModelSupport.Settings settings2 = new FoldingModelSupport.Settings(settings.getContextRange(), settings.isExpandByDefault());
        if (settings2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getFoldingModelSettings"));
        }
        return settings2;
    }

    @NotNull
    public static TextDiffSettingsHolder.TextDiffSettings getTextSettings(@NotNull DiffContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getTextSettings"));
        }
        TextDiffSettingsHolder.TextDiffSettings settings = (TextDiffSettingsHolder.TextDiffSettings)context.getUserData(TextDiffSettingsHolder.TextDiffSettings.KEY);
        if (settings == null) {
            settings = TextDiffSettingsHolder.TextDiffSettings.getSettings((String)context.getUserData(DiffUserDataKeys.PLACE));
            context.putUserData(TextDiffSettingsHolder.TextDiffSettings.KEY, (Object)settings);
            if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, new UserDataHolder[]{context})) {
                settings.setIgnorePolicy(IgnorePolicy.DEFAULT);
            }
        }
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = settings;
        if (textDiffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getTextSettings"));
        }
        return textDiffSettings;
    }

    @NotNull
    public static boolean[] checkForceReadOnly(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkForceReadOnly"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkForceReadOnly"));
        }
        int contentCount = request.getContents().size();
        boolean[] result2 = new boolean[contentCount];
        if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.FORCE_READ_ONLY, new UserDataHolder[]{request, context})) {
            Arrays.fill(result2, true);
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkForceReadOnly"));
            }
            return result2;
        }
        boolean[] data = (boolean[])request.getUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS);
        if (data != null && data.length == contentCount) {
            if (data == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkForceReadOnly"));
            }
            return data;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkForceReadOnly"));
        }
        return result2;
    }

    public static void installDocumentListeners(@NotNull DocumentListener listener2, @NotNull List<Document> documents, @NotNull Disposable disposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "installDocumentListeners"));
        }
        if (documents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "installDocumentListeners"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "installDocumentListeners"));
        }
        for (Document document : ContainerUtil.newHashSet(documents)) {
            document.addDocumentListener(listener2, disposable);
        }
    }

    public static void checkDifferentDocuments(@NotNull ContentDiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkDifferentDocuments"));
        }
        List contents = request.getContents();
        boolean sameDocuments = false;
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            for (int j = i2 + 1; j < contents.size(); ++j) {
                DiffContent content1 = (DiffContent)contents.get(i2);
                DiffContent content2 = (DiffContent)contents.get(j);
                if (!(content1 instanceof DocumentContent) || !(content2 instanceof DocumentContent)) continue;
                sameDocuments |= ((DocumentContent)content1).getDocument() == ((DocumentContent)content2).getDocument();
            }
        }
        if (sameDocuments) {
            StringBuilder message = new StringBuilder();
            message.append("DiffRequest with same documents detected\n");
            message.append(request.toString()).append("\n");
            for (DiffContent content : contents) {
                message.append(content.toString()).append("\n");
            }
            LOG.warn(new Throwable(message.toString()));
        }
    }

    public static boolean areEqualLineSeparators(@NotNull List<? extends DiffContent> contents) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "areEqualLineSeparators"));
        }
        return TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::getLineSeparator);
    }

    public static boolean areEqualCharsets(@NotNull List<? extends DiffContent> contents) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "areEqualCharsets"));
        }
        boolean sameCharset = TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::getCharset);
        boolean sameBOM = TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::hasBom);
        return sameCharset && sameBOM;
    }

    private static <T> boolean areEqualDocumentContentProperties(@NotNull List<? extends DiffContent> contents, @NotNull Function<DocumentContent, T> propertyGetter) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "areEqualDocumentContentProperties"));
        }
        if (propertyGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyGetter", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "areEqualDocumentContentProperties"));
        }
        List properties = ContainerUtil.mapNotNull(contents, content -> {
            if (propertyGetter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyGetter", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "lambda$areEqualDocumentContentProperties$0"));
            }
            if (content instanceof EmptyContent) {
                return null;
            }
            return propertyGetter.fun((Object)((DocumentContent)content));
        });
        if (properties.size() < 2) {
            return true;
        }
        return ContainerUtil.newHashSet((Iterable)properties).size() == 1;
    }

    @NotNull
    public static List<? extends EditorEx> getEditableEditors(@NotNull List<? extends EditorEx> editors) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getEditableEditors"));
        }
        List list = ContainerUtil.filter(editors, (Condition)new Condition<EditorEx>(){

            public boolean value(EditorEx editor) {
                return !editor.isViewer();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getEditableEditors"));
        }
        return list;
    }

    public static class EditorActionsPopup
    extends EditorPopupHandler {
        @NotNull
        private final List<? extends AnAction> myEditorPopupActions;

        public EditorActionsPopup(@NotNull List<? extends AnAction> editorPopupActions) {
            if (editorPopupActions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorPopupActions", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorActionsPopup", "<init>"));
            }
            this.myEditorPopupActions = editorPopupActions;
        }

        public void install(@NotNull List<? extends EditorEx> editors) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorActionsPopup", "install"));
            }
            for (EditorEx editorEx : editors) {
                editorEx.addEditorMouseListener((EditorMouseListener)this);
                editorEx.setContextMenuGroupId(null);
            }
        }

        @Override
        public void invokePopup(EditorMouseEvent event) {
            if (this.myEditorPopupActions.isEmpty()) {
                return;
            }
            DefaultActionGroup group = new DefaultActionGroup(this.myEditorPopupActions);
            EditorPopupHandler handler2 = EditorActionUtil.createEditorPopupHandler((ActionGroup)group);
            handler2.invokePopup(event);
        }
    }

    public static class EditorFontSizeSynchronizer
    implements PropertyChangeListener {
        @NotNull
        private final List<? extends EditorEx> myEditors;
        private boolean myDuringUpdate;

        public EditorFontSizeSynchronizer(@NotNull List<? extends EditorEx> editors) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorFontSizeSynchronizer", "<init>"));
            }
            this.myDuringUpdate = false;
            this.myEditors = editors;
        }

        public void install(@NotNull Disposable disposable) {
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorFontSizeSynchronizer", "install"));
            }
            if (this.myEditors.size() < 2) {
                return;
            }
            for (EditorEx editorEx : this.myEditors) {
                editorEx.addPropertyChangeListener(this, disposable);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate) {
                return;
            }
            if (!"fontSize".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            int fontSize = (Integer)evt.getNewValue();
            for (EditorEx editorEx : this.myEditors) {
                if (evt.getSource() == editorEx) continue;
                this.updateEditor(editorEx, fontSize);
            }
        }

        public void updateEditor(@NotNull EditorEx editor, int fontSize) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorFontSizeSynchronizer", "updateEditor"));
            }
            try {
                this.myDuringUpdate = true;
                editor.setFontSize(fontSize);
            }
            finally {
                this.myDuringUpdate = false;
            }
        }
    }

    public static class EditorReadOnlyLockAction
    extends ReadOnlyLockAction {
        private final List<? extends EditorEx> myEditableEditors;

        public EditorReadOnlyLockAction(@NotNull DiffContext context, @NotNull List<? extends EditorEx> editableEditors) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorReadOnlyLockAction", "<init>"));
            }
            if (editableEditors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editableEditors", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorReadOnlyLockAction", "<init>"));
            }
            super(context);
            this.myEditableEditors = editableEditors;
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            for (EditorEx editorEx : this.myEditableEditors) {
                editorEx.setViewer(readOnly);
            }
        }

        @Override
        protected boolean canEdit() {
            return !this.myEditableEditors.isEmpty();
        }
    }

    public static abstract class ReadOnlyLockAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        protected final DiffContext myContext;
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ReadOnlyLockAction(@NotNull DiffContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ReadOnlyLockAction", "<init>"));
            }
            super("Disable editing", null, AllIcons.Nodes.Padlock);
            this.myContext = context;
            this.mySettings = TextDiffViewerUtil.getTextSettings(context);
        }

        protected void applyDefaults() {
            if (this.isVisible()) {
                this.setSelected(null, this.isSelected(null));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ReadOnlyLockAction", "update"));
            }
            if (!this.isVisible()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                super.update(e);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySettings.isReadOnlyLock();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setReadOnlyLock(state);
            this.doApply(state);
        }

        private boolean isVisible() {
            return this.myContext.getUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK) == Boolean.TRUE && this.canEdit();
        }

        protected abstract void doApply(boolean var1);

        protected abstract boolean canEdit();
    }

    public static abstract class ToggleExpandByDefaultAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleExpandByDefaultAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ToggleExpandByDefaultAction", "<init>"));
            }
            super("Collapse unchanged fragments", AllIcons.Actions.Collapseall);
            this.mySettings = settings;
        }

        public boolean isVisible() {
            return this.mySettings.getContextRange() != -1;
        }

        public boolean isSelected(AnActionEvent e) {
            return !this.mySettings.isExpandByDefault();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            boolean expand;
            boolean bl = expand = !state;
            if (this.mySettings.isExpandByDefault() == expand) {
                return;
            }
            this.mySettings.setExpandByDefault(expand);
            this.expandAll(expand);
        }

        protected abstract void expandAll(boolean var1);
    }

    public static class ToggleAutoScrollAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleAutoScrollAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ToggleAutoScrollAction", "<init>"));
            }
            super("Synchronize Scrolling", AllIcons.Actions.SynchronizeScrolling);
            this.mySettings = settings;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySettings.isEnableSyncScroll();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setEnableSyncScroll(state);
        }
    }

    public static class IgnorePolicySettingAction
    extends EnumPolicySettingAction<IgnorePolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public IgnorePolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, IgnorePolicy ... policies) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "<init>"));
            }
            if (policies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policies", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "<init>"));
            }
            super((Enum[])policies);
            this.mySettings = settings;
        }

        @Override
        protected void setValue(@NotNull IgnorePolicy option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "setValue"));
            }
            if (this.getValue() == option) {
                return;
            }
            UsageTrigger.trigger("diff.TextDiffSettings.IgnorePolicy." + option.name());
            this.mySettings.setIgnorePolicy(option);
        }

        @Override
        @NotNull
        protected IgnorePolicy getStoredValue() {
            IgnorePolicy ignorePolicy = this.mySettings.getIgnorePolicy();
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getStoredValue"));
            }
            return ignorePolicy;
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getValueSubstitutes(@NotNull IgnorePolicy value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getValueSubstitutes"));
            }
            if (value == IgnorePolicy.IGNORE_WHITESPACES_CHUNKS) {
                List list = ContainerUtil.list((Object[])new IgnorePolicy[]{IgnorePolicy.IGNORE_WHITESPACES});
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getValueSubstitutes"));
                }
                return list;
            }
            if (value == IgnorePolicy.FORMATTING) {
                List list = ContainerUtil.list((Object[])new IgnorePolicy[]{IgnorePolicy.TRIM_WHITESPACES});
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getValueSubstitutes"));
                }
                return list;
            }
            List list = ContainerUtil.list((Object[])new IgnorePolicy[]{IgnorePolicy.DEFAULT});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getValueSubstitutes"));
            }
            return list;
        }

        @Override
        @NotNull
        protected String getText(@NotNull IgnorePolicy option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getText"));
            }
            String string = option.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getText"));
            }
            return string;
        }
    }

    public static class HighlightPolicySettingAction
    extends EnumPolicySettingAction<HighlightPolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public HighlightPolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, HighlightPolicy ... policies) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "<init>"));
            }
            if (policies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policies", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "<init>"));
            }
            super((Enum[])policies);
            this.mySettings = settings;
        }

        @Override
        protected void setValue(@NotNull HighlightPolicy option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "setValue"));
            }
            if (this.getValue() == option) {
                return;
            }
            UsageTrigger.trigger("diff.TextDiffSettings.HighlightPolicy." + option.name());
            this.mySettings.setHighlightPolicy(option);
        }

        @Override
        @NotNull
        protected HighlightPolicy getStoredValue() {
            HighlightPolicy highlightPolicy = this.mySettings.getHighlightPolicy();
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getStoredValue"));
            }
            return highlightPolicy;
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getValueSubstitutes(@NotNull HighlightPolicy value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getValueSubstitutes"));
            }
            if (value == HighlightPolicy.BY_WORD_SPLIT) {
                List list = ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_WORD});
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getValueSubstitutes"));
                }
                return list;
            }
            if (value == HighlightPolicy.DO_NOT_HIGHLIGHT) {
                List list = ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE});
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getValueSubstitutes"));
                }
                return list;
            }
            List list = ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_WORD});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getValueSubstitutes"));
            }
            return list;
        }

        @Override
        @NotNull
        protected String getText(@NotNull HighlightPolicy option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getText"));
            }
            String string = option.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getText"));
            }
            return string;
        }
    }

    private static abstract class EnumPolicySettingAction<T extends Enum>
    extends ComboBoxSettingAction<T> {
        @NotNull
        private final T[] myPolicies;

        public EnumPolicySettingAction(@NotNull T[] policies) {
            if (policies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policies", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EnumPolicySettingAction", "<init>"));
            }
            assert (policies.length > 0);
            this.myPolicies = policies;
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabledAndVisible(this.myPolicies.length > 1);
        }

        @Override
        @NotNull
        protected List<T> getAvailableOptions() {
            List list = ContainerUtil.sorted(Arrays.asList(this.myPolicies));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EnumPolicySettingAction", "getAvailableOptions"));
            }
            return list;
        }

        @Override
        @NotNull
        public T getValue() {
            T value = this.getStoredValue();
            if (ArrayUtil.contains(value, (Object[])this.myPolicies)) {
                T t = value;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EnumPolicySettingAction", "getValue"));
                }
                return t;
            }
            List<T> substitutes = this.getValueSubstitutes(value);
            for (Enum substitute : substitutes) {
                if (!ArrayUtil.contains((Object)substitute, (Object[])this.myPolicies)) continue;
                Enum enum_ = substitute;
                if (enum_ == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EnumPolicySettingAction", "getValue"));
                }
                return (T)enum_;
            }
            T t = this.myPolicies[0];
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EnumPolicySettingAction", "getValue"));
            }
            return t;
        }

        @NotNull
        protected abstract T getStoredValue();

        @NotNull
        protected abstract List<T> getValueSubstitutes(@NotNull T var1);
    }

    public static abstract class ComboBoxSettingAction<T>
    extends ComboBoxAction
    implements DumbAware {
        private DefaultActionGroup myActions;

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setText(this.getText(this.getValue()));
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup defaultActionGroup = this.getActions();
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        @NotNull
        public DefaultActionGroup getActions() {
            if (this.myActions == null) {
                this.myActions = new DefaultActionGroup();
                for (T setting : this.getAvailableOptions()) {
                    this.myActions.add((AnAction)new MyAction(setting));
                }
            }
            DefaultActionGroup defaultActionGroup = this.myActions;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction", "getActions"));
            }
            return defaultActionGroup;
        }

        @NotNull
        protected abstract List<T> getAvailableOptions();

        @NotNull
        protected abstract T getValue();

        protected abstract void setValue(@NotNull T var1);

        @NotNull
        protected abstract String getText(@NotNull T var1);

        private class MyAction
        extends AnAction
        implements DumbAware {
            @NotNull
            private final T myOption;

            public MyAction(T option) {
                if (option == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction$MyAction", "<init>"));
                }
                super(ComboBoxSettingAction.this.getText(option));
                this.myOption = option;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction$MyAction", "actionPerformed"));
                }
                ComboBoxSettingAction.this.setValue(this.myOption);
            }
        }
    }
}

