/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.psi.PsiElement;
import java.util.List;

public class TreePsiFragment
extends PsiFragment {
    private final NodeSpecificHasher myHasher;

    public TreePsiFragment(NodeSpecificHasher hasher, PsiElement root, int cost) {
        super(root, cost);
        this.myHasher = hasher;
    }

    public TreePsiFragment(NodeSpecificHasher hasher, List<? extends PsiElement> element, int from, int to) {
        super(element, from, to);
        this.myHasher = hasher;
    }

    @Override
    public boolean isEqual(PsiElement[] elements, int discardCost) {
        if (elements.length != this.myElementAnchors.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.myElementAnchors.length; ++i2) {
            PsiElement one = this.myElementAnchors[i2].retrieve();
            PsiElement two = elements[i2];
            if (one != null && two != null && this.myHasher.areTreesEqual(one, two, discardCost)) continue;
            return false;
        }
        return true;
    }
}

