/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExecutionTargetManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExecutionTargetManagerImpl
extends ExecutionTargetManager
implements PersistentStateComponent<Element> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myActiveTargetLock;
    @Nullable
    private ExecutionTarget myActiveTarget;
    @Nullable
    private String mySavedActiveTargetId;

    public ExecutionTargetManagerImpl(@NotNull Project project2, @NotNull RunManager runManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionTargetManagerImpl", "<init>"));
        }
        if (runManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runManager", "com/intellij/execution/ExecutionTargetManagerImpl", "<init>"));
        }
        this.myActiveTargetLock = new Object();
        this.myProject = project2;
        ((RunManagerEx)runManager).addRunManagerListener(new RunManagerListener(){

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/ExecutionTargetManagerImpl$1", "runConfigurationChanged"));
                }
                if (settings == RunManager.getInstance((Project)ExecutionTargetManagerImpl.this.myProject).getSelectedConfiguration()) {
                    ExecutionTargetManagerImpl.this.updateActiveTarget(settings);
                }
            }

            @Override
            public void runConfigurationSelected() {
                ExecutionTargetManagerImpl.this.updateActiveTarget();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            String id;
            Element state = new Element("state");
            String string = id = this.myActiveTarget == null ? this.mySavedActiveTargetId : this.myActiveTarget.getId();
            if (id != null) {
                state.setAttribute("SELECTED_TARGET", id);
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element state) {
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (this.myActiveTarget == null && this.mySavedActiveTargetId == null) {
                this.mySavedActiveTargetId = state.getAttributeValue("SELECTED_TARGET");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ExecutionTarget getActiveTarget() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myActiveTargetLock;
        // MONITORENTER : object
        if (this.myActiveTarget == null) {
            this.updateActiveTarget();
        }
        ExecutionTarget executionTarget = this.myActiveTarget;
        // MONITOREXIT : object
        if (executionTarget != null) return executionTarget;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManagerImpl", "getActiveTarget"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveTarget(@NotNull ExecutionTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/execution/ExecutionTargetManagerImpl", "setActiveTarget"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            this.updateActiveTarget(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), target);
        }
    }

    private void updateActiveTarget() {
        this.updateActiveTarget(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration());
    }

    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings) {
        this.updateActiveTarget(settings, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget toSelect) {
        ExecutionTarget toNotify;
        List<ExecutionTarget> suitable = settings == null ? Collections.singletonList(DefaultExecutionTarget.INSTANCE) : this.getTargetsFor(settings);
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (toSelect == null) {
                toSelect = this.myActiveTarget;
            }
            int index = -1;
            if (toSelect != null) {
                index = suitable.indexOf(toSelect);
            } else if (this.mySavedActiveTargetId != null) {
                int size = suitable.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    if (!suitable.get(i2).getId().equals(this.mySavedActiveTargetId)) continue;
                    index = i2;
                    break;
                }
            }
            toNotify = this.doSetActiveTarget(index >= 0 ? suitable.get(index) : (ExecutionTarget)ContainerUtil.getFirstItem(suitable, (Object)DefaultExecutionTarget.INSTANCE));
        }
        if (toNotify != null) {
            ((ExecutionTargetListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).activeTargetChanged(toNotify);
        }
    }

    @Nullable
    private ExecutionTarget doSetActiveTarget(@NotNull ExecutionTarget newTarget) {
        if (newTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTarget", "com/intellij/execution/ExecutionTargetManagerImpl", "doSetActiveTarget"));
        }
        this.mySavedActiveTargetId = null;
        ExecutionTarget prev = this.myActiveTarget;
        this.myActiveTarget = newTarget;
        if (prev != null && !prev.equals((Object)this.myActiveTarget)) {
            return this.myActiveTarget;
        }
        return null;
    }

    @NotNull
    public List<ExecutionTarget> getTargetsFor(@Nullable RunnerAndConfigurationSettings settings) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (settings == null) {
            List<ExecutionTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManagerImpl", "getTargetsFor"));
            }
            return list;
        }
        ArrayList<ExecutionTarget> result2 = new ArrayList<ExecutionTarget>();
        for (ExecutionTargetProvider eachTargetProvider : (ExecutionTargetProvider[])Extensions.getExtensions((ExtensionPointName)ExecutionTargetProvider.EXTENSION_NAME)) {
            for (ExecutionTarget eachTarget : eachTargetProvider.getTargets(this.myProject, settings)) {
                if (!ExecutionTargetManagerImpl.canRun((RunnerAndConfigurationSettings)settings, (ExecutionTarget)eachTarget)) continue;
                result2.add(eachTarget);
            }
        }
        List<ExecutionTarget> list = Collections.unmodifiableList(result2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManagerImpl", "getTargetsFor"));
        }
        return list;
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateActiveTarget();
    }
}

