/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.RunConfigurationExtensionBase;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationExtension
extends RunConfigurationExtensionBase<RunConfigurationBase> {
    public static final ExtensionPointName<RunConfigurationExtension> EP_NAME = new ExtensionPointName("com.intellij.runConfigurationExtension");

    public abstract <T extends RunConfigurationBase> void updateJavaParameters(T var1, JavaParameters var2, RunnerSettings var3) throws ExecutionException;

    protected void patchCommandLine(@NotNull RunConfigurationBase configuration, RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/RunConfigurationExtension", "patchCommandLine"));
        }
        if (cmdLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdLine", "com/intellij/execution/RunConfigurationExtension", "patchCommandLine"));
        }
        if (runnerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnerId", "com/intellij/execution/RunConfigurationExtension", "patchCommandLine"));
        }
    }

    protected boolean isEnabledFor(@NotNull RunConfigurationBase applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicableConfiguration", "com/intellij/execution/RunConfigurationExtension", "isEnabledFor"));
        }
        return true;
    }

    protected void extendTemplateConfiguration(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/RunConfigurationExtension", "extendTemplateConfiguration"));
        }
    }

    public void cleanUserData(RunConfigurationBase runConfigurationBase) {
    }

    public static void cleanExtensionsUserData(RunConfigurationBase runConfigurationBase) {
        for (RunConfigurationExtension extension : (RunConfigurationExtension[])Extensions.getExtensions(EP_NAME)) {
            extension.cleanUserData(runConfigurationBase);
        }
    }

    public RefactoringElementListener wrapElementListener(PsiElement element, RunConfigurationBase runJavaConfiguration, RefactoringElementListener listener2) {
        return listener2;
    }

    public static RefactoringElementListener wrapRefactoringElementListener(PsiElement element, RunConfigurationBase runConfigurationBase, RefactoringElementListener listener2) {
        for (RunConfigurationExtension extension : (RunConfigurationExtension[])Extensions.getExtensions(EP_NAME)) {
            listener2 = extension.wrapElementListener(element, runConfigurationBase, listener2);
        }
        return listener2;
    }

    public boolean isListenerDisabled(RunConfigurationBase configuration, Object listener2, RunnerSettings runnerSettings) {
        return false;
    }
}

