/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConsoleHistoryModel
extends SimpleModificationTracker {
    private final Object myLock;
    private final LinkedList<String> myEntries;
    private int myIndex;

    ConsoleHistoryModel(@Nullable ConsoleHistoryModel masterModel) {
        LinkedList<String> linkedList;
        if (masterModel == null) {
            LinkedList<String> linkedList2;
            linkedList = linkedList2;
        } else {
            linkedList = masterModel.myEntries;
        }
        this.myEntries = linkedList;
        this.myLock = masterModel == null ? this : masterModel.myLock;
        this.resetIndex();
    }

    ConsoleHistoryModel copy() {
        return new ConsoleHistoryModel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEntries(@NotNull List<String> entries) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/execution/console/ConsoleHistoryModel", "resetEntries"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.clear();
            this.myEntries.addAll(entries.subList(0, Math.min(entries.size(), this.getMaxHistorySize())));
            this.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToHistory(@Nullable String statement2) {
        if (StringUtil.isEmptyOrSpaces((String)statement2)) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            int maxHistorySize = this.getMaxHistorySize();
            this.myEntries.remove(statement2);
            int size = this.myEntries.size();
            if (size >= maxHistorySize && size > 0) {
                this.myEntries.removeFirst();
            }
            this.myEntries.addLast(statement2);
            this.incModificationCount();
        }
    }

    public void incModificationCount() {
        this.resetIndex();
        super.incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetIndex() {
        Object object = this.myLock;
        synchronized (object) {
            this.myIndex = this.myEntries.size();
        }
    }

    public int getMaxHistorySize() {
        return UISettings.getInstance().getConsoleCommandHistoryLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromHistory(String statement2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.remove(statement2);
            this.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getEntries() {
        Object object = this.myLock;
        synchronized (object) {
            return ContainerUtil.newArrayList(this.myEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myEntries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistorySize() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myEntries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getHistoryNext() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIndex >= 0) {
                --this.myIndex;
            }
            return this.getCurrentEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getHistoryPrev() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIndex <= this.myEntries.size() - 1) {
                ++this.myIndex;
            }
            return this.getCurrentEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHistory(boolean next) {
        Object object = this.myLock;
        synchronized (object) {
            return next ? this.myIndex > 0 : this.myIndex < this.myEntries.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCurrentEntry() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIndex >= 0 && this.myIndex < this.myEntries.size() ? this.myEntries.get(this.myIndex) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentIndex() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIndex;
        }
    }
}

