/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunConfigurationTreeAction;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

public class CopyConfigurationAction
extends RunConfigurationTreeAction {
    public CopyConfigurationAction() {
        super(ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), PlatformIcons.COPY_ICON);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/dashboard/actions/CopyConfigurationAction", "update"));
        }
        super.update(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setText(ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]) + "...");
        }
    }

    protected boolean isEnabled4(DashboardRunConfigurationNode node) {
        return RunManager.getInstance((Project)node.getProject()).getAllConfigurationsList().contains(node.getConfigurationSettings().getConfiguration());
    }

    protected void doActionPerformed(DashboardRunConfigurationNode node) {
        RunManagerEx runManager = RunManagerEx.getInstanceEx(node.getProject());
        RunnerAndConfigurationSettings settings = node.getConfigurationSettings();
        RunnerAndConfigurationSettings copiedSettings = ((RunnerAndConfigurationSettingsImpl)settings).clone();
        runManager.setUniqueNameIfNeed(copiedSettings);
        copiedSettings.setFolderName(settings.getFolderName());
        ConfigurationFactory factory = settings.getFactory();
        if (factory instanceof ConfigurationFactoryEx) {
            ((ConfigurationFactoryEx)factory).onConfigurationCopied(settings.getConfiguration());
        }
        if (RunDialog.editConfiguration(node.getProject(), copiedSettings, ExecutionBundle.message((String)"run.dashboard.edit.configuration.dialog.title", (Object[])new Object[0]))) {
            runManager.addConfiguration(copiedSettings, runManager.isConfigurationShared(settings), runManager.getBeforeRunTasks(settings.getConfiguration()), false);
        }
    }
}

