/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.DashboardGroup;
import com.intellij.execution.dashboard.DashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.DashboardGrouper;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunConfigurationDashboardGroupingRule;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDashboardTreeStructure
extends AbstractTreeStructureBase {
    private final Project myProject;
    private final List<DashboardGrouper> myGroupers;
    private final RunConfigurationsTreeRootNode myRootElement;

    public RunDashboardTreeStructure(@NotNull Project project2, @NotNull List<DashboardGrouper> groupers) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/dashboard/tree/RunDashboardTreeStructure", "<init>"));
        }
        if (groupers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupers", "com/intellij/execution/dashboard/tree/RunDashboardTreeStructure", "<init>"));
        }
        super(project2);
        this.myProject = project2;
        this.myGroupers = groupers;
        this.myRootElement = new RunConfigurationsTreeRootNode();
    }

    @Override
    @Nullable
    public List<TreeStructureProvider> getProviders() {
        return Collections.emptyList();
    }

    public Object getRootElement() {
        return this.myRootElement;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    private static Collection<? extends AbstractTreeNode> group(Project project2, AbstractTreeNode parent, List<DashboardGroupingRule> rules, final List<RunConfigurationNode> nodes) {
        if (rules.isEmpty()) {
            return nodes;
        }
        ArrayList<DashboardGroupingRule> remaining = new ArrayList<DashboardGroupingRule>(rules);
        DashboardGroupingRule rule = (DashboardGroupingRule)remaining.remove(0);
        Map groups = nodes.stream().collect(HashMap::new, (map, node) -> map.computeIfAbsent(rule.getGroup((AbstractTreeNode)node), key2 -> new ArrayList()).add(node), (firstMap, secondMap) -> firstMap.forEach((key2, value) -> value.addAll((Collection)secondMap.get(key2))));
        ArrayList result2 = new ArrayList();
        ArrayList ungroupedNodes = new ArrayList();
        groups.forEach((group, groupedNodes) -> {
            if (group == null || !rule.shouldGroupSingleNodes() && groupedNodes.size() == 1) {
                ungroupedNodes.addAll(RunDashboardTreeStructure.group(project2, parent, remaining, groupedNodes));
            } else {
                GroupingNode node = new GroupingNode(project2, parent.getValue(), (DashboardGroup)group);
                node.addChildren(RunDashboardTreeStructure.group(project2, node, remaining, groupedNodes));
                result2.add(node);
            }
        });
        if (rule instanceof RunConfigurationDashboardGroupingRule) {
            result2.addAll(ungroupedNodes);
            Collections.sort(result2, new Comparator<AbstractTreeNode>(){

                @Override
                public int compare(AbstractTreeNode n1, AbstractTreeNode n2) {
                    RunConfigurationNode first = this.getNode(n1);
                    RunConfigurationNode second = this.getNode(n2);
                    return nodes.indexOf((Object)first) - nodes.indexOf((Object)second);
                }

                private RunConfigurationNode getNode(AbstractTreeNode node) {
                    Object runConfigurationNode;
                    if (node instanceof GroupingNode) {
                        Optional child = node.getChildren().stream().findFirst();
                        assert (child.isPresent());
                        runConfigurationNode = child.get();
                    } else {
                        runConfigurationNode = node;
                    }
                    assert (runConfigurationNode instanceof RunConfigurationNode);
                    return (RunConfigurationNode)((Object)runConfigurationNode);
                }
            });
        } else {
            Collections.sort(result2, Comparator.comparing(node -> ((GroupingNode)((Object)node)).getGroup().getName()));
            result2.addAll(ungroupedNodes);
        }
        return result2;
    }

    public class RunConfigurationsTreeRootNode
    extends AbstractTreeNode<Object> {
        public RunConfigurationsTreeRootNode() {
            super(RunDashboardTreeStructure.this.myProject, new Object());
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            List nodes = RunDashboardManager.getInstance((Project)this.myProject).getRunConfigurations().stream().map(value -> new RunConfigurationNode(this.myProject, (Pair<RunnerAndConfigurationSettings, RunContentDescriptor>)value)).collect(Collectors.toList());
            Collection collection = RunDashboardTreeStructure.group(this.myProject, this, RunDashboardTreeStructure.this.myGroupers.stream().filter(DashboardGrouper::isEnabled).map(DashboardGrouper::getRule).collect(Collectors.toList()), nodes);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/tree/RunDashboardTreeStructure$RunConfigurationsTreeRootNode", "getChildren"));
            }
            return collection;
        }

        protected void update(PresentationData presentation) {
        }
    }
}

