/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.PatternHyperlinkPart;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PatternHyperlinkFormat {
    private final Pattern myPattern;
    private final boolean myZeroBasedLineNumbering;
    private final boolean myZeroBasedColumnNumbering;
    private final PatternHyperlinkPart[] myLinkParts;

    public PatternHyperlinkFormat(@NotNull Pattern pattern, boolean zeroBasedLineNumbering, boolean zeroBasedColumnNumbering, PatternHyperlinkPart ... linkParts) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/execution/filters/PatternHyperlinkFormat", "<init>"));
        }
        if (linkParts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkParts", "com/intellij/execution/filters/PatternHyperlinkFormat", "<init>"));
        }
        this.myPattern = pattern;
        this.myZeroBasedLineNumbering = zeroBasedLineNumbering;
        this.myZeroBasedColumnNumbering = zeroBasedColumnNumbering;
        this.myLinkParts = linkParts;
    }

    @NotNull
    public Pattern getPattern() {
        Pattern pattern = this.myPattern;
        if (pattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/PatternHyperlinkFormat", "getPattern"));
        }
        return pattern;
    }

    public boolean isZeroBasedLineNumbering() {
        return this.myZeroBasedLineNumbering;
    }

    public boolean isZeroBasedColumnNumbering() {
        return this.myZeroBasedColumnNumbering;
    }

    @NotNull
    public PatternHyperlinkPart[] getLinkParts() {
        if (this.myLinkParts == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/PatternHyperlinkFormat", "getLinkParts"));
        }
        return this.myLinkParts;
    }
}

