/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.ProjectTopics;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ModuleRunConfigurationManager")
public final class ModuleRunConfigurationManager
implements PersistentStateComponent<Element> {
    private static final String SHARED = "shared";
    private static final String LOCAL = "local";
    private static final Object LOCK = new Object();
    private static final Logger LOG = Logger.getInstance(ModuleRunConfigurationManager.class);
    @NotNull
    private final Module myModule;
    @NotNull
    private final Condition<RunnerAndConfigurationSettings> myModuleConfigCondition;
    @NotNull
    private final RunManagerImpl myManager;
    @Nullable
    private List<Element> myUnloadedElements;

    public ModuleRunConfigurationManager(@NotNull Module module2, @NotNull RunManagerImpl runManager) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/execution/impl/ModuleRunConfigurationManager", "<init>"));
        }
        if (runManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runManager", "com/intellij/execution/impl/ModuleRunConfigurationManager", "<init>"));
        }
        this.myModuleConfigCondition = settings -> settings != null && this.usesMyModule(settings.getConfiguration());
        this.myUnloadedElements = null;
        this.myModule = module2;
        this.myManager = runManager;
        this.myModule.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeModuleRemoved(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ModuleRunConfigurationManager$1", "beforeModuleRemoved"));
                }
                if (module2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/execution/impl/ModuleRunConfigurationManager$1", "beforeModuleRemoved"));
                }
                if (ModuleRunConfigurationManager.this.myModule.equals(module2)) {
                    LOG.debug("time to remove something from project (" + project2 + ")");
                    Object object = LOCK;
                    synchronized (object) {
                        ModuleRunConfigurationManager.this.getModuleRunConfigurationSettings().forEach(settings -> ModuleRunConfigurationManager.this.myManager.removeConfiguration((RunnerAndConfigurationSettings)settings));
                    }
                }
            }
        });
    }

    @Nullable
    public Element getState() {
        try {
            return new Element("state").addContent(this.writeExternal(new Element(SHARED), true)).addContent(this.writeExternal(new Element(LOCAL), false));
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Collection<? extends RunnerAndConfigurationSettings> getModuleRunConfigurationSettings() {
        List list = ContainerUtil.filter(this.myManager.getConfigurationSettings(), this.myModuleConfigCondition);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ModuleRunConfigurationManager", "getModuleRunConfigurationSettings"));
        }
        return list;
    }

    private boolean usesMyModule(RunConfiguration config) {
        return config instanceof ModuleBasedConfiguration && this.myModule.equals(((ModuleBasedConfiguration)config).getConfigurationModule().getModule());
    }

    public Element writeExternal(@NotNull Element element, boolean isShared) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/ModuleRunConfigurationManager", "writeExternal"));
        }
        LOG.debug("writeExternal(" + this.myModule + "); shared: " + isShared);
        this.getModuleRunConfigurationSettings().stream().filter(settings -> this.myManager.isConfigurationShared((RunnerAndConfigurationSettings)settings) == isShared).forEach(settings -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/ModuleRunConfigurationManager", "lambda$writeExternal$2"));
            }
            this.myManager.addConfigurationElement(element, (RunnerAndConfigurationSettings)settings);
        });
        if (this.myUnloadedElements != null) {
            this.myUnloadedElements.forEach(unloadedElement -> {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/ModuleRunConfigurationManager", "lambda$writeExternal$3"));
                }
                element.addContent(unloadedElement.clone());
            });
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/ModuleRunConfigurationManager", "readExternal"));
        }
        Object object = LOCK;
        synchronized (object) {
            Element localElement;
            this.myUnloadedElements = null;
            Element sharedElement = element.getChild(SHARED);
            if (sharedElement != null) {
                this.doReadExternal(sharedElement, true);
            }
            if ((localElement = element.getChild(LOCAL)) != null) {
                this.doReadExternal(localElement, false);
            }
        }
    }

    private void doReadExternal(@NotNull Element element, boolean isShared) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/ModuleRunConfigurationManager", "doReadExternal"));
        }
        LOG.debug("readExternal(" + this.myModule + ");  shared: " + isShared);
        for (Element child : element.getChildren()) {
            RunnerAndConfigurationSettings configuration = this.myManager.loadConfiguration(child, isShared);
            if (configuration != null || !Comparing.strEqual((String)element.getName(), (String)"configuration")) continue;
            if (this.myUnloadedElements == null) {
                this.myUnloadedElements = new ArrayList<Element>(2);
            }
            this.myUnloadedElements.add(element);
        }
        this.myManager.setOrdered(false);
        this.myManager.getSortedConfigurations();
    }
}

