/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import org.jetbrains.annotations.NotNull;

public class NameGeneratingListenerDecorator
implements RefactoringElementListener,
UndoRefactoringElementListener {
    private final LocatableConfiguration myConfiguration;
    private final RefactoringElementListener myListener;

    public NameGeneratingListenerDecorator(LocatableConfiguration configuration, RefactoringElementListener listener2) {
        this.myConfiguration = configuration;
        this.myListener = listener2;
    }

    public void elementMoved(@NotNull PsiElement newElement) {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/execution/impl/NameGeneratingListenerDecorator", "elementMoved"));
        }
        boolean hasGeneratedName = this.myConfiguration.isGeneratedName();
        this.myListener.elementMoved(newElement);
        if (hasGeneratedName) {
            this.myConfiguration.setName(this.myConfiguration.suggestedName());
        }
    }

    public void elementRenamed(@NotNull PsiElement newElement) {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/execution/impl/NameGeneratingListenerDecorator", "elementRenamed"));
        }
        boolean hasGeneratedName = this.myConfiguration.isGeneratedName();
        this.myListener.elementRenamed(newElement);
        if (hasGeneratedName) {
            this.myConfiguration.setName(this.myConfiguration.suggestedName());
        }
    }

    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/execution/impl/NameGeneratingListenerDecorator", "undoElementMovedOrRenamed"));
        }
        if (oldQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/execution/impl/NameGeneratingListenerDecorator", "undoElementMovedOrRenamed"));
        }
        if (this.myListener instanceof UndoRefactoringElementListener) {
            boolean hasGeneratedName = this.myConfiguration.isGeneratedName();
            ((UndoRefactoringElementListener)this.myListener).undoElementMovedOrRenamed(newElement, oldQualifiedName);
            if (hasGeneratedName) {
                this.myConfiguration.setName(this.myConfiguration.suggestedName());
            }
        }
    }
}

