/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ColoredProcessHandler
extends KillableProcessHandler
implements AnsiEscapeDecoder.ColoredTextAcceptor {
    private final AnsiEscapeDecoder myAnsiEscapeDecoder;
    private final List<AnsiEscapeDecoder.ColoredTextAcceptor> myColoredTextListeners;

    public ColoredProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/ColoredProcessHandler", "<init>"));
        }
        super(commandLine);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myColoredTextListeners = ContainerUtil.newArrayList();
        this.setShouldKillProcessSoftly(false);
    }

    public ColoredProcessHandler(@NotNull Process process2, String commandLine) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/ColoredProcessHandler", "<init>"));
        }
        super(process2, commandLine);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myColoredTextListeners = ContainerUtil.newArrayList();
        this.setShouldKillProcessSoftly(false);
    }

    public ColoredProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/ColoredProcessHandler", "<init>"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/execution/process/ColoredProcessHandler", "<init>"));
        }
        super(process2, commandLine, charset);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myColoredTextListeners = ContainerUtil.newArrayList();
        this.setShouldKillProcessSoftly(false);
    }

    public final void notifyTextAvailable(String text, Key outputType) {
        this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/process/ColoredProcessHandler", "coloredTextAvailable"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/execution/process/ColoredProcessHandler", "coloredTextAvailable"));
        }
        this.textAvailable(text, attributes);
        this.notifyColoredListeners(text, attributes);
    }

    protected void notifyColoredListeners(String text, Key attributes) {
        for (AnsiEscapeDecoder.ColoredTextAcceptor listener2 : this.myColoredTextListeners) {
            listener2.coloredTextAvailable(text, attributes);
        }
    }

    public void addColoredTextListener(AnsiEscapeDecoder.ColoredTextAcceptor listener2) {
        this.myColoredTextListeners.add(listener2);
    }

    public void removeColoredTextListener(AnsiEscapeDecoder.ColoredTextAcceptor listener2) {
        this.myColoredTextListeners.remove(listener2);
    }

    protected void textAvailable(String text, Key attributes) {
        super.notifyTextAvailable(text, attributes);
    }
}

