/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupRunner
implements StartupActivity,
DumbAware {
    public static final int DELAY_MILLIS = 200;

    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupRunner", "runActivity"));
        }
        final ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project2);
        if (projectStartupTaskManager.isEmpty()) {
            return;
        }
        RunManagerImpl.getInstanceImpl(project2).addRunManagerListener(new RunManagerListener(){

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationRemoved"));
                }
                projectStartupTaskManager.delete(settings.getUniqueID());
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, String existingId) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationChanged"));
                }
                if (existingId != null) {
                    projectStartupTaskManager.rename(existingId, settings);
                }
                projectStartupTaskManager.checkOnChange(settings);
            }

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationAdded"));
                }
                projectStartupTaskManager.checkOnChange(settings);
            }
        });
        ProjectStartupRunner.scheduleRunActivities(project2);
    }

    private static void scheduleRunActivities(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupRunner", "scheduleRunActivities"));
        }
        JobScheduler.getScheduler().schedule(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupRunner", "lambda$scheduleRunActivities$0"));
            }
            if (!((StartupManagerEx)StartupManager.getInstance((Project)project2)).postStartupActivityPassed() && !Registry.is((String)"dumb.aware.run.configurations")) {
                ProjectStartupRunner.scheduleRunActivities(project2);
            } else {
                ProjectStartupRunner.runActivities(project2);
            }
        }, 200L, TimeUnit.MILLISECONDS);
    }

    private static void runActivities(Project project2) {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project2);
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(projectStartupTaskManager.getLocalConfigurations());
        configurations.addAll(projectStartupTaskManager.getSharedConfigurations());
        ApplicationManager.getApplication().invokeLater(() -> {
            long pause = 0L;
            Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project2);
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            for (RunnerAndConfigurationSettings configuration : configurations) {
                if (!ProjectStartupRunner.canBeRun(configuration)) {
                    ProjectStartupRunner.showNotification(project2, "Run Configuration '" + configuration.getName() + "' can not be started with 'Run' action.", MessageType.ERROR);
                    return;
                }
                try {
                    alarm.addRequest((Runnable)new MyExecutor(executor, configuration, alarm), pause);
                }
                catch (ExecutionException e) {
                    ProjectStartupRunner.showNotification(project2, e.getMessage(), MessageType.ERROR);
                }
                pause = 300L;
            }
        });
    }

    private static void showNotification(Project project2, String text, MessageType type) {
        ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  " + text, type).notify(project2);
    }

    public static boolean canBeRun(@NotNull RunnerAndConfigurationSettings configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/startup/ProjectStartupRunner", "canBeRun"));
        }
        return RunnerRegistry.getInstance().getRunner(DefaultRunExecutor.EXECUTOR_ID, (RunProfile)configuration.getConfiguration()) != null;
    }

    private static class MyExecutor
    implements Runnable {
        public static final int ATTEMPTS = 10;
        private final ExecutionEnvironment myEnvironment;
        @NotNull
        private final Alarm myAlarm;
        private final Project myProject;
        private int myCnt;
        private static final long PAUSE = 300L;
        private final String myName;

        public MyExecutor(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Alarm alarm) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/startup/ProjectStartupRunner$MyExecutor", "<init>"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/startup/ProjectStartupRunner$MyExecutor", "<init>"));
            }
            if (alarm == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alarm", "com/intellij/execution/startup/ProjectStartupRunner$MyExecutor", "<init>"));
            }
            this.myCnt = 10;
            this.myName = configuration.getName();
            this.myProject = configuration.getConfiguration().getProject();
            this.myAlarm = alarm;
            this.myEnvironment = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)configuration).contentToReuse(null).dataContext(null).activeTarget().build();
        }

        @Override
        public void run() {
            if (ExecutorRegistry.getInstance().isStarting(this.myEnvironment)) {
                if (this.myCnt <= 0) {
                    ProjectStartupRunner.showNotification(this.myProject, "'" + this.myName + "' not started after " + 10 + " attempts.", MessageType.ERROR);
                    return;
                }
                --this.myCnt;
                this.myAlarm.addRequest((Runnable)this, 300L);
            }
            ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  starting '" + this.myName + "'", MessageType.INFO).notify(this.myProject);
            ProgramRunnerUtil.executeConfiguration(this.myEnvironment, true, true);
            if (this.myAlarm.isEmpty()) {
                Disposer.dispose((Disposable)this.myAlarm);
            }
        }
    }
}

