/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testframework.autotest.AbstractAutoTestManager;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

@State(name="JavaAutoRunManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class JavaAutoRunManager
extends AbstractAutoTestManager {
    @NotNull
    public static JavaAutoRunManager getInstance(Project project2) {
        JavaAutoRunManager javaAutoRunManager = (JavaAutoRunManager)ServiceManager.getService((Project)project2, JavaAutoRunManager.class);
        if (javaAutoRunManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/JavaAutoRunManager", "getInstance"));
        }
        return javaAutoRunManager;
    }

    public JavaAutoRunManager(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testDiscovery/JavaAutoRunManager", "<init>"));
        }
        super(project2);
    }

    @Override
    @NotNull
    protected AutoTestWatcher createWatcher(final Project project2) {
        AutoTestWatcher autoTestWatcher = new AutoTestWatcher(){
            private boolean myHasErrors = false;
            private CompilationStatusListener myStatusListener;

            @Override
            public void activate() {
                if (this.myStatusListener == null) {
                    this.myStatusListener = new CompilationStatusListener(){
                        private boolean myFoundFilesToMake = false;

                        public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                            if (!this.myFoundFilesToMake) {
                                return;
                            }
                            if (errors == 0) {
                                JavaAutoRunManager.this.restartAllAutoTests(0);
                            }
                            myHasErrors = errors == 0;
                            this.myFoundFilesToMake = false;
                        }

                        public void automakeCompilationFinished(int errors, int warnings, CompileContext compileContext) {
                            this.compilationFinished(false, errors, warnings, compileContext);
                        }

                        public void fileGenerated(String outputRoot, String relativePath) {
                            this.myFoundFilesToMake = true;
                        }
                    };
                    CompilerManager.getInstance((Project)project2).addCompilationStatusListener(this.myStatusListener, (Disposable)project2);
                }
            }

            @Override
            public void deactivate() {
                if (this.myStatusListener != null) {
                    CompilerManager.getInstance((Project)project2).removeCompilationStatusListener(this.myStatusListener);
                }
            }

            @Override
            public boolean isUpToDate(int modificationStamp) {
                return !this.myHasErrors;
            }
        };
        if (autoTestWatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/JavaAutoRunManager", "createWatcher"));
        }
        return autoTestWatcher;
    }
}

