/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUrlProvider
implements SMTestLocator,
DumbAware {
    public static final FileUrlProvider INSTANCE = new FileUrlProvider();

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        String filePath;
        int lineNumber;
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        if (!"file".equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
            }
            return list;
        }
        String normalizedPath = path.replace(File.separatorChar, '/');
        int lineNoSeparatorIndex = normalizedPath.lastIndexOf(58);
        if (lineNoSeparatorIndex > 3) {
            lineNumber = StringUtil.parseInt((String)normalizedPath.substring(lineNoSeparatorIndex + 1), (int)-1);
            filePath = normalizedPath.substring(0, lineNoSeparatorIndex);
        } else {
            lineNumber = -1;
            filePath = normalizedPath;
        }
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)filePath);
        List<VirtualFile> virtualFiles = TestsLocationProviderUtil.findSuitableFilesFor(systemIndependentPath, project2);
        if (virtualFiles.isEmpty()) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
            }
            return list;
        }
        ArrayList<Location> locations = new ArrayList<Location>(2);
        for (VirtualFile file2 : virtualFiles) {
            locations.add(FileUrlProvider.createLocationFor(project2, file2, lineNumber));
        }
        ArrayList<Location> arrayList = locations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        return arrayList;
    }

    @Nullable
    public static Location createLocationFor(@NotNull Project project2, @NotNull VirtualFile virtualFile, int lineNum) {
        int length;
        int endOffset;
        int lineStartOffset;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/FileUrlProvider", "createLocationFor"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/execution/testframework/sm/FileUrlProvider", "createLocationFor"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        if (lineNum <= 0) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        Document doc = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        int lineCount = doc.getLineCount();
        if (lineNum <= lineCount) {
            lineStartOffset = doc.getLineStartOffset(lineNum - 1);
            endOffset = doc.getLineEndOffset(lineNum - 1);
        } else {
            lineStartOffset = 0;
            endOffset = doc.getTextLength();
        }
        PsiElement elementAtLine = null;
        for (int offset = lineStartOffset; offset <= endOffset && (elementAtLine = psiFile.findElementAt(offset)) instanceof PsiWhiteSpace; offset += (length = elementAtLine.getTextLength()) > 1 ? length - 1 : 1) {
        }
        return PsiLocation.fromPsiElement((Project)project2, (PsiElement)(elementAtLine != null ? elementAtLine : psiFile));
    }
}

