/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GeneralTestEventsProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)GeneralTestEventsProcessor.class.getName());
    protected final SMTRunnerEventsListener myEventPublisher;
    private final String myTestFrameworkName;
    private final Project myProject;
    private TransferToEDTQueue<Runnable> myTransferToEDTQueue;
    protected List<SMTRunnerEventsListener> myListenerAdapters;

    public GeneralTestEventsProcessor(Project project2, @NotNull String testFrameworkName) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/runner/GeneralTestEventsProcessor", "<init>"));
        }
        this.myListenerAdapters = new ArrayList<SMTRunnerEventsListener>();
        this.myProject = project2;
        this.myEventPublisher = (SMTRunnerEventsListener)project2.getMessageBus().syncPublisher(SMTRunnerEventsListener.TEST_STATUS);
        this.myTestFrameworkName = testFrameworkName;
        this.myTransferToEDTQueue = new TransferToEDTQueue("SM queue", runnable2 -> {
            runnable2.run();
            return true;
        }, project2.getDisposed(), 300);
    }

    public void onRootPresentationAdded(String rootName, String comment, String rootLocation) {
    }

    public void onSuiteTreeNodeAdded(String testName, String locationHint) {
    }

    public void onSuiteTreeStarted(String suiteName, String locationHint) {
    }

    public void onSuiteTreeEnded(String suiteName) {
    }

    public void onBuildTreeEnded() {
    }

    public abstract void onStartTesting();

    protected void fireOnTestingStarted(SMTestProxy.SMRootTestProxy node) {
        this.myEventPublisher.onTestingStarted(node);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestingStarted(node);
        }
    }

    public abstract void onTestsCountInSuite(int var1);

    protected void fireOnTestsCountInSuite(int count) {
        this.myEventPublisher.onTestsCountInSuite(count);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestsCountInSuite(count);
        }
    }

    public abstract void onTestStarted(@NotNull TestStartedEvent var1);

    protected void fireOnTestStarted(SMTestProxy testProxy) {
        this.myEventPublisher.onTestStarted(testProxy);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestStarted(testProxy);
        }
    }

    public abstract void onTestFinished(@NotNull TestFinishedEvent var1);

    protected void fireOnTestFinished(SMTestProxy testProxy) {
        this.myEventPublisher.onTestFinished(testProxy);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestFinished(testProxy);
        }
    }

    public abstract void onTestFailure(@NotNull TestFailedEvent var1);

    protected void fireOnTestFailed(SMTestProxy testProxy) {
        this.myEventPublisher.onTestFailed(testProxy);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestFailed(testProxy);
        }
    }

    public abstract void onTestIgnored(@NotNull TestIgnoredEvent var1);

    protected void fireOnTestIgnored(SMTestProxy testProxy) {
        this.myEventPublisher.onTestIgnored(testProxy);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestIgnored(testProxy);
        }
    }

    public abstract void onTestOutput(@NotNull TestOutputEvent var1);

    public abstract void onSuiteStarted(@NotNull TestSuiteStartedEvent var1);

    protected void fireOnSuiteStarted(SMTestProxy newSuite) {
        this.myEventPublisher.onSuiteStarted(newSuite);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onSuiteStarted(newSuite);
        }
    }

    public abstract void onSuiteFinished(@NotNull TestSuiteFinishedEvent var1);

    protected void fireOnSuiteFinished(SMTestProxy mySuite) {
        this.myEventPublisher.onSuiteFinished(mySuite);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onSuiteFinished(mySuite);
        }
    }

    public abstract void onUncapturedOutput(@NotNull String var1, Key var2);

    public abstract void onError(@NotNull String var1, @Nullable String var2, boolean var3);

    protected static void fireOnTestsReporterAttached(SMTestProxy.SMRootTestProxy rootNode) {
        rootNode.setTestsReporterAttached();
    }

    public abstract void onFinishTesting();

    protected void fireOnTestingFinished(SMTestProxy.SMRootTestProxy root) {
        this.myEventPublisher.onTestingFinished(root);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestingFinished(root);
        }
    }

    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.addToInvokeLater(() -> {
            this.myEventPublisher.onCustomProgressTestsCategory(categoryName, testCount);
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onCustomProgressTestsCategory(categoryName, testCount);
            }
        });
    }

    public void onCustomProgressTestStarted() {
        this.addToInvokeLater(() -> {
            this.myEventPublisher.onCustomProgressTestStarted();
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onCustomProgressTestStarted();
            }
        });
    }

    public void onCustomProgressTestFinished() {
        this.addToInvokeLater(() -> {
            this.myEventPublisher.onCustomProgressTestFinished();
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onCustomProgressTestFinished();
            }
        });
    }

    public void onCustomProgressTestFailed() {
        this.addToInvokeLater(() -> {
            this.myEventPublisher.onCustomProgressTestFailed();
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onCustomProgressTestFailed();
            }
        });
    }

    public abstract void onTestsReporterAttached();

    public abstract void setLocator(@NotNull SMTestLocator var1);

    public void addEventsListener(@NotNull SMTRunnerEventsListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/testframework/sm/runner/GeneralTestEventsProcessor", "addEventsListener"));
        }
        this.myListenerAdapters.add(listener2);
    }

    public abstract void setPrinterProvider(@NotNull TestProxyPrinterProvider var1);

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (GeneralTestEventsProcessor.this.myProject.isDisposed()) {
                        return;
                    }
                    GeneralTestEventsProcessor.this.myTransferToEDTQueue.drain();
                }
            });
        }
    }

    protected void disconnectListeners() {
        this.myListenerAdapters.clear();
    }

    public Condition getDisposedCondition() {
        return Condition.FALSE;
    }

    public void addToInvokeLater(Runnable runnable2) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
        } else if (application.isHeadlessEnvironment() || SwingUtilities.isEventDispatchThread()) {
            runnable2.run();
        } else {
            this.myTransferToEDTQueue.offer((Object)runnable2);
        }
    }

    public void stopEventProcessing() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myTransferToEDTQueue.drain();
        });
    }

    protected static <T> boolean isTreeComplete(Collection<T> runningTests, SMTestProxy.SMRootTestProxy rootNode) {
        if (!runningTests.isEmpty()) {
            return false;
        }
        List<? extends SMTestProxy> children2 = rootNode.getChildren();
        for (SMTestProxy sMTestProxy : children2) {
            if (sMTestProxy.isFinal() && !sMTestProxy.wasTerminated()) continue;
            return false;
        }
        return true;
    }

    protected void logProblem(String msg) {
        GeneralTestEventsProcessor.logProblem(LOG, msg, this.myTestFrameworkName);
    }

    protected void logProblem(String msg, boolean throwError) {
        GeneralTestEventsProcessor.logProblem(LOG, msg, throwError, this.myTestFrameworkName);
    }

    public static String getTFrameworkPrefix(String testFrameworkName) {
        return "[" + testFrameworkName + "]: ";
    }

    public static void logProblem(Logger log, String msg, String testFrameworkName) {
        GeneralTestEventsProcessor.logProblem(log, msg, SMTestRunnerConnectionUtil.isInDebugMode(), testFrameworkName);
    }

    public static void logProblem(Logger log, String msg, boolean throwError, String testFrameworkName) {
        String text = GeneralTestEventsProcessor.getTFrameworkPrefix(testFrameworkName) + msg;
        if (throwError) {
            log.error(text);
        } else {
            log.warn(text);
        }
    }
}

