/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetEditorContextBase
extends UserDataHolderBase
implements FacetEditorContext {
    private final FacetsProvider myFacetsProvider;
    @Nullable
    private final FacetEditorContext myParentContext;
    private final ModulesProvider myModulesProvider;
    private final Facet myFacet;
    private final UserDataHolder mySharedModuleData;
    private final UserDataHolder mySharedProjectData;

    public FacetEditorContextBase(@NotNull Facet facet, @Nullable FacetEditorContext parentContext, @Nullable FacetsProvider facetsProvider, @NotNull ModulesProvider modulesProvider, UserDataHolder sharedModuleData, UserDataHolder sharedProjectData) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/ui/FacetEditorContextBase", "<init>"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/facet/impl/ui/FacetEditorContextBase", "<init>"));
        }
        this.myFacet = facet;
        this.mySharedProjectData = sharedProjectData;
        this.mySharedModuleData = sharedModuleData;
        this.myParentContext = parentContext;
        this.myModulesProvider = modulesProvider;
        this.myFacetsProvider = facetsProvider != null ? facetsProvider : DefaultFacetsProvider.INSTANCE;
    }

    public Library[] getLibraries() {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.getProject()).getLibraries();
    }

    @NotNull
    public String getFacetName() {
        String string = this.myFacet.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetEditorContextBase", "getFacetName"));
        }
        return string;
    }

    public VirtualFile[] getLibraryFiles(Library library, OrderRootType rootType) {
        return library.getFiles(rootType);
    }

    @Nullable
    public Library findLibrary(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/facet/impl/ui/FacetEditorContextBase", "findLibrary"));
        }
        for (Library library : this.getLibraries()) {
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    public UserDataHolder getSharedProjectData() {
        return this.mySharedProjectData;
    }

    public UserDataHolder getSharedModuleData() {
        return this.mySharedModuleData;
    }

    @NotNull
    public abstract ArtifactsStructureConfigurableContext getArtifactsStructureContext();

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/facet/impl/ui/FacetEditorContextBase", "getUserData"));
        }
        Object t = super.getUserData(key2);
        if (t == null && this.myParentContext != null) {
            t = this.myParentContext.getUserData(key2);
        }
        return (T)t;
    }

    @NotNull
    public FacetsProvider getFacetsProvider() {
        FacetsProvider facetsProvider = this.myFacetsProvider;
        if (facetsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetEditorContextBase", "getFacetsProvider"));
        }
        return facetsProvider;
    }

    @NotNull
    public ModulesProvider getModulesProvider() {
        ModulesProvider modulesProvider = this.myModulesProvider;
        if (modulesProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetEditorContextBase", "getModulesProvider"));
        }
        return modulesProvider;
    }

    @NotNull
    public ModuleRootModel getRootModel() {
        ModifiableRootModel modifiableRootModel = this.getModifiableRootModel();
        if (modifiableRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetEditorContextBase", "getRootModel"));
        }
        return modifiableRootModel;
    }

    public abstract LibrariesContainer getContainer();

    @NotNull
    public Facet getFacet() {
        Facet facet = this.myFacet;
        if (facet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetEditorContextBase", "getFacet"));
        }
        return facet;
    }

    @Nullable
    public Facet getParentFacet() {
        return this.myFacet.getUnderlyingFacet();
    }
}

