/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CustomUsageSearcher;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.findUsages.PsiElement2UsageTargetComposite;
import com.intellij.find.findUsages.UsageHistory;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findParameterUsages.FindUsagesManager");
    private static final Key<String> KEY_START_USAGE_AGAIN = Key.create((String)"KEY_START_USAGE_AGAIN");
    @NonNls
    private static final String VALUE_START_USAGE_AGAIN = "START_AGAIN";
    private final Project myProject;
    private final UsageViewManager myAnotherManager;
    private PsiElement2UsageTargetComposite myLastSearchInFileData;
    private final UsageHistory myHistory;

    public FindUsagesManager(@NotNull Project project2, @NotNull UsageViewManager anotherManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/FindUsagesManager", "<init>"));
        }
        if (anotherManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anotherManager", "com/intellij/find/findUsages/FindUsagesManager", "<init>"));
        }
        this.myHistory = new UsageHistory();
        this.myProject = project2;
        this.myAnotherManager = anotherManager;
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/FindUsagesManager", "canFindUsages"));
        }
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            try {
                if (!factory.canFindUsages(element)) continue;
                return true;
            }
            catch (IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    public void clearFindingNextUsageInFile() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLastSearchInFileData = null;
    }

    public boolean findNextUsageInFile(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/findUsages/FindUsagesManager", "findNextUsageInFile"));
        }
        return this.findUsageInFile(editor, FileSearchScope.AFTER_CARET);
    }

    public boolean findPreviousUsageInFile(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/findUsages/FindUsagesManager", "findPreviousUsageInFile"));
        }
        return this.findUsageInFile(editor, FileSearchScope.BEFORE_CARET);
    }

    private boolean findUsageInFile(@NotNull FileEditor editor, @NotNull FileSearchScope direction) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/findUsages/FindUsagesManager", "findUsageInFile"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/intellij/find/findUsages/FindUsagesManager", "findUsageInFile"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myLastSearchInFileData == null) {
            return false;
        }
        PsiElement[] primaryElements = this.myLastSearchInFileData.getPrimaryElements();
        PsiElement[] secondaryElements = this.myLastSearchInFileData.getSecondaryElements();
        if (primaryElements.length == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)FindBundle.message("find.searched.elements.have.been.changed.error", new Object[0]), (String)FindBundle.message("cannot.search.for.usages.title", new Object[0]), (Icon)Messages.getInformationIcon());
            return false;
        }
        TextEditor textEditor = (TextEditor)editor;
        Document document = textEditor.getEditor().getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        FindUsagesHandler handler2 = this.getFindUsagesHandler(primaryElements[0], false);
        if (handler2 == null) {
            return false;
        }
        this.findUsagesInEditor(primaryElements, secondaryElements, handler2, psiFile, direction, this.myLastSearchInFileData.myOptions, (FileEditor)textEditor);
        return true;
    }

    private void initLastSearchElement(@NotNull FindUsagesOptions findUsagesOptions, @NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements) {
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "initLastSearchElement"));
        }
        if (primaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/find/findUsages/FindUsagesManager", "initLastSearchElement"));
        }
        if (secondaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryElements", "com/intellij/find/findUsages/FindUsagesManager", "initLastSearchElement"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLastSearchInFileData = new PsiElement2UsageTargetComposite(primaryElements, secondaryElements, findUsagesOptions);
    }

    @Nullable
    public FindUsagesHandler getFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/FindUsagesManager", "getFindUsagesHandler"));
        }
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            if (!factory.canFindUsages(element)) continue;
            FindUsagesHandler handler2 = factory.createFindUsagesHandler(element, forHighlightUsages);
            if (handler2 == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    public FindUsagesHandler getNewFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/FindUsagesManager", "getNewFindUsagesHandler"));
        }
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            if (!factory.canFindUsages(element)) continue;
            Class<?> aClass = factory.getClass();
            FindUsagesHandlerFactory copy = (FindUsagesHandlerFactory)new CachingConstructorInjectionComponentAdapter((Object)aClass.getName(), aClass).getComponentInstance(this.myProject.getPicoContainer());
            FindUsagesHandler handler2 = copy.createFindUsagesHandler(element, forHighlightUsages);
            if (handler2 == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    public void findUsages(@NotNull PsiElement psiElement, PsiFile scopeFile, FileEditor editor, boolean showDialog, @Nullable(value="null means default (stored in options)") SearchScope searchScope) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/find/findUsages/FindUsagesManager", "findUsages"));
        }
        FindUsagesHandler handler2 = this.getFindUsagesHandler(psiElement, false);
        if (handler2 == null) {
            return;
        }
        boolean singleFile = scopeFile != null;
        AbstractFindUsagesDialog dialog2 = handler2.getFindUsagesDialog(singleFile, this.shouldOpenInNewTab(), this.mustOpenInNewTab());
        if (showDialog) {
            if (!dialog2.showAndGet()) {
                return;
            }
        } else {
            dialog2.close(0);
        }
        this.setOpenInNewTab(dialog2.isShowInSeparateWindow());
        FindUsagesOptions findUsagesOptions = dialog2.calcFindUsagesOptions();
        if (searchScope != null) {
            findUsagesOptions.searchScope = searchScope;
        }
        this.clearFindingNextUsageInFile();
        this.startFindUsages(findUsagesOptions, handler2, scopeFile, editor);
    }

    void startFindUsages(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions findUsagesOptions, PsiFile scopeFile, FileEditor editor) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/find/findUsages/FindUsagesManager", "startFindUsages"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "startFindUsages"));
        }
        FindUsagesHandler handler2 = this.getFindUsagesHandler(psiElement, false);
        if (handler2 == null) {
            return;
        }
        this.startFindUsages(findUsagesOptions, handler2, scopeFile, editor);
    }

    private void startFindUsages(@NotNull FindUsagesOptions findUsagesOptions, @NotNull FindUsagesHandler handler2, PsiFile scopeFile, FileEditor editor) {
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "startFindUsages"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "startFindUsages"));
        }
        boolean singleFile = scopeFile != null;
        this.clearFindingNextUsageInFile();
        LOG.assertTrue(handler2.getPsiElement().isValid());
        PsiElement[] primaryElements = handler2.getPrimaryElements();
        FindUsagesManager.checkNotNull(primaryElements, handler2, "getPrimaryElements()");
        PsiElement[] secondaryElements = handler2.getSecondaryElements();
        FindUsagesManager.checkNotNull(secondaryElements, handler2, "getSecondaryElements()");
        if (singleFile) {
            editor.putUserData(KEY_START_USAGE_AGAIN, null);
            this.findUsagesInEditor(primaryElements, secondaryElements, handler2, scopeFile, FileSearchScope.FROM_START, findUsagesOptions.clone(), editor);
        } else {
            boolean skipResultsWithOneUsage = FindSettings.getInstance().isSkipResultsWithOneUsage();
            this.findUsages(primaryElements, secondaryElements, handler2, findUsagesOptions, skipResultsWithOneUsage);
        }
    }

    public static void showSettingsAndFindUsages(@NotNull NavigationItem[] targets) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/find/findUsages/FindUsagesManager", "showSettingsAndFindUsages"));
        }
        if (targets.length == 0) {
            return;
        }
        NavigationItem target = targets[0];
        if (!(target instanceof ConfigurableUsageTarget)) {
            return;
        }
        ((ConfigurableUsageTarget)target).showSettings();
    }

    private static void checkNotNull(@NotNull PsiElement[] elements, @NotNull FindUsagesHandler handler2, @NonNls @NotNull String methodName) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/find/findUsages/FindUsagesManager", "checkNotNull"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "checkNotNull"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/find/findUsages/FindUsagesManager", "checkNotNull"));
        }
        for (PsiElement element : elements) {
            if (element != null) continue;
            LOG.error(handler2 + "." + methodName + " has returned array with null elements: " + Arrays.asList(elements));
        }
    }

    @NotNull
    public static ProgressIndicator startProcessUsages(final @NotNull FindUsagesHandler handler2, final @NotNull PsiElement[] primaryElements, final @NotNull PsiElement[] secondaryElements, final @NotNull Processor<Usage> processor2, final @NotNull FindUsagesOptions findUsagesOptions, @NotNull Runnable onComplete) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "startProcessUsages"));
        }
        if (primaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/find/findUsages/FindUsagesManager", "startProcessUsages"));
        }
        if (secondaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryElements", "com/intellij/find/findUsages/FindUsagesManager", "startProcessUsages"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/FindUsagesManager", "startProcessUsages"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "startProcessUsages"));
        }
        if (onComplete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onComplete", "com/intellij/find/findUsages/FindUsagesManager", "startProcessUsages"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        Task.Backgroundable task = new Task.Backgroundable(handler2.getProject(), "Finding Usages"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/findUsages/FindUsagesManager$1", "run"));
                }
                UsageSearcher usageSearcher = (UsageSearcher)ReadAction.compute(() -> {
                    if (primaryElements == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/find/findUsages/FindUsagesManager$1", "lambda$run$0"));
                    }
                    if (secondaryElements == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryElements", "com/intellij/find/findUsages/FindUsagesManager$1", "lambda$run$0"));
                    }
                    if (handler2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager$1", "lambda$run$0"));
                    }
                    if (findUsagesOptions == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager$1", "lambda$run$0"));
                    }
                    PsiElement2UsageTargetAdapter[] primaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements);
                    PsiElement2UsageTargetAdapter[] secondaryTargets = PsiElement2UsageTargetAdapter.convert(secondaryElements);
                    return FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, null);
                });
                usageSearcher.generate(processor2);
            }
        };
        ((ProgressManagerImpl)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, indicator, onComplete);
        ProgressIndicatorBase progressIndicatorBase = indicator;
        if (progressIndicatorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesManager", "startProcessUsages"));
        }
        return progressIndicatorBase;
    }

    @NotNull
    public UsageViewPresentation createPresentation(@NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions findUsagesOptions) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "createPresentation"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "createPresentation"));
        }
        PsiElement element = handler2.getPsiElement();
        LOG.assertTrue(element.isValid());
        UsageViewPresentation usageViewPresentation = FindUsagesManager.createPresentation(element, findUsagesOptions, FindSettings.getInstance().isShowResultsInSeparateView());
        if (usageViewPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesManager", "createPresentation"));
        }
        return usageViewPresentation;
    }

    private void setOpenInNewTab(boolean toOpenInNewTab) {
        if (!this.mustOpenInNewTab()) {
            FindSettings.getInstance().setShowResultsInSeparateView(toOpenInNewTab);
        }
    }

    private boolean shouldOpenInNewTab() {
        return this.mustOpenInNewTab() || FindSettings.getInstance().isShowResultsInSeparateView();
    }

    private boolean mustOpenInNewTab() {
        Content selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
        return selectedContent != null && selectedContent.isPinned();
    }

    @NotNull
    private static UsageSearcher createUsageSearcher(@NotNull PsiElement2UsageTargetAdapter[] primaryTargets, @NotNull PsiElement2UsageTargetAdapter[] secondaryTargets, @NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions options, PsiFile scopeFile) throws PsiInvalidElementAccessException {
        if (primaryTargets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryTargets", "com/intellij/find/findUsages/FindUsagesManager", "createUsageSearcher"));
        }
        if (secondaryTargets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryTargets", "com/intellij/find/findUsages/FindUsagesManager", "createUsageSearcher"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "createUsageSearcher"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/FindUsagesManager", "createUsageSearcher"));
        }
        ReadAction.run(() -> {
            if (primaryTargets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryTargets", "com/intellij/find/findUsages/FindUsagesManager", "lambda$createUsageSearcher$1"));
            }
            if (secondaryTargets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryTargets", "com/intellij/find/findUsages/FindUsagesManager", "lambda$createUsageSearcher$1"));
            }
            PsiElement[] primaryElements = PsiElement2UsageTargetAdapter.convertToPsiElements(primaryTargets);
            PsiElement[] secondaryElements = PsiElement2UsageTargetAdapter.convertToPsiElements(secondaryTargets);
            ContainerUtil.concat((Object[][])new PsiElement[][]{primaryElements, secondaryElements}).forEach(psi -> {
                if (psi == null || !psi.isValid()) {
                    throw new PsiInvalidElementAccessException(psi);
                }
            });
        });
        FindUsagesOptions optionsClone = options.clone();
        UsageSearcher usageSearcher = processor2 -> {
            if (primaryTargets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryTargets", "com/intellij/find/findUsages/FindUsagesManager", "lambda$createUsageSearcher$9"));
            }
            if (secondaryTargets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryTargets", "com/intellij/find/findUsages/FindUsagesManager", "lambda$createUsageSearcher$9"));
            }
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "lambda$createUsageSearcher$9"));
            }
            PsiElement[] primaryElements = (PsiElement[])ReadAction.compute(() -> {
                if (primaryTargets == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryTargets", "com/intellij/find/findUsages/FindUsagesManager", "lambda$null$2"));
                }
                return PsiElement2UsageTargetAdapter.convertToPsiElements(primaryTargets);
            });
            PsiElement[] secondaryElements = (PsiElement[])ReadAction.compute(() -> {
                if (secondaryTargets == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryTargets", "com/intellij/find/findUsages/FindUsagesManager", "lambda$null$3"));
                }
                return PsiElement2UsageTargetAdapter.convertToPsiElements(secondaryTargets);
            });
            Project project2 = (Project)ReadAction.compute(() -> scopeFile != null ? scopeFile.getProject() : primaryElements[0].getProject());
            FindUsagesManager.dropResolveCacheRegularly(ProgressManager.getInstance().getProgressIndicator(), project2);
            if (scopeFile != null) {
                optionsClone.searchScope = new LocalSearchScope((PsiElement)scopeFile);
            }
            CommonProcessors.UniqueProcessor usageInfoProcessor = new CommonProcessors.UniqueProcessor(usageInfo -> {
                Usage usage = (Usage)ReadAction.compute(() -> UsageInfoToUsageConverter.convert((PsiElement[])primaryElements, (UsageInfo)usageInfo));
                return processor2.process((Object)usage);
            });
            Iterable elements = ContainerUtil.concat((Object[][])new PsiElement[][]{primaryElements, secondaryElements});
            optionsClone.fastTrack = new SearchRequestCollector(new SearchSession());
            if (optionsClone.searchScope instanceof GlobalSearchScope) {
                optionsClone.searchScope = optionsClone.searchScope.union((SearchScope)GlobalSearchScope.projectScope((Project)project2));
            }
            try {
                for (PsiElement element : elements) {
                    handler2.processElementUsages(element, (Processor<UsageInfo>)usageInfoProcessor, optionsClone);
                    for (CustomUsageSearcher searcher : (CustomUsageSearcher[])Extensions.getExtensions(CustomUsageSearcher.EP_NAME)) {
                        try {
                            searcher.processElementUsages(element, (Processor<Usage>)processor2, optionsClone);
                        }
                        catch (IndexNotReadyException e) {
                            DumbService.getInstance((Project)element.getProject()).showDumbModeNotification("Find usages is not available during indexing");
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                PsiSearchHelper.SERVICE.getInstance((Project)project2).processRequests(optionsClone.fastTrack, arg_0 -> FindUsagesManager.lambda$null$8((Processor)usageInfoProcessor, arg_0));
            }
            finally {
                optionsClone.fastTrack = null;
            }
        };
        if (usageSearcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesManager", "createUsageSearcher"));
        }
        return usageSearcher;
    }

    @NotNull
    private static PsiElement2UsageTargetAdapter[] convertToUsageTargets(@NotNull Iterable<PsiElement> elementsToSearch, @NotNull FindUsagesOptions findUsagesOptions) {
        if (elementsToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToSearch", "com/intellij/find/findUsages/FindUsagesManager", "convertToUsageTargets"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "convertToUsageTargets"));
        }
        List targets = ContainerUtil.map(elementsToSearch, element -> {
            if (findUsagesOptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "lambda$convertToUsageTargets$10"));
            }
            return FindUsagesManager.convertToUsageTarget(element, findUsagesOptions);
        });
        PsiElement2UsageTargetAdapter[] psiElement2UsageTargetAdapterArray = targets.toArray(new PsiElement2UsageTargetAdapter[targets.size()]);
        if (psiElement2UsageTargetAdapterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesManager", "convertToUsageTargets"));
        }
        return psiElement2UsageTargetAdapterArray;
    }

    public void findUsages(@NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements, @NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions findUsagesOptions, boolean toSkipUsagePanelWhenOneUsage) {
        if (primaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/find/findUsages/FindUsagesManager", "findUsages"));
        }
        if (secondaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryElements", "com/intellij/find/findUsages/FindUsagesManager", "findUsages"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "findUsages"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "findUsages"));
        }
        this.doFindUsages(primaryElements, secondaryElements, handler2, findUsagesOptions, toSkipUsagePanelWhenOneUsage);
    }

    public UsageView doFindUsages(@NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements, @NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions findUsagesOptions, boolean toSkipUsagePanelWhenOneUsage) {
        if (primaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/find/findUsages/FindUsagesManager", "doFindUsages"));
        }
        if (secondaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryElements", "com/intellij/find/findUsages/FindUsagesManager", "doFindUsages"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "doFindUsages"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "doFindUsages"));
        }
        if (primaryElements.length == 0) {
            throw new AssertionError((Object)(handler2 + " " + findUsagesOptions));
        }
        Object[] primaryTargets = FindUsagesManager.convertToUsageTargets(Arrays.asList(primaryElements), findUsagesOptions);
        Object[] secondaryTargets = FindUsagesManager.convertToUsageTargets(Arrays.asList(secondaryElements), findUsagesOptions);
        PsiElement2UsageTargetAdapter[] targets = (PsiElement2UsageTargetAdapter[])ArrayUtil.mergeArrays((Object[])primaryTargets, (Object[])secondaryTargets);
        Factory factory = () -> FindUsagesManager.lambda$doFindUsages$11((PsiElement2UsageTargetAdapter[])primaryTargets, (PsiElement2UsageTargetAdapter[])secondaryTargets, handler2, findUsagesOptions);
        UsageView usageView = this.myAnotherManager.searchAndShowUsages((UsageTarget[])targets, factory, !toSkipUsagePanelWhenOneUsage, true, FindUsagesManager.createPresentation(primaryElements[0], findUsagesOptions, this.shouldOpenInNewTab()), null);
        this.myHistory.add(targets[0]);
        return usageView;
    }

    private static void dropResolveCacheRegularly(ProgressIndicator indicator, final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/FindUsagesManager", "dropResolveCacheRegularly"));
        }
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate(new ProgressIndicatorBase(){
                volatile long lastCleared = System.currentTimeMillis();

                @Override
                public void setFraction(double fraction) {
                    super.setFraction(fraction);
                    long current = System.currentTimeMillis();
                    if (current - this.lastCleared >= 500L) {
                        this.lastCleared = current;
                        PsiManager.getInstance((Project)project2).dropResolveCaches();
                    }
                }
            });
        }
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions options, boolean toOpenInNewTab) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/find/findUsages/FindUsagesManager", "createPresentation"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/FindUsagesManager", "createPresentation"));
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        String scopeString = options.searchScope.getDisplayName();
        presentation.setScopeText(scopeString);
        String usagesString = FindUsagesManager.generateUsagesString(options);
        presentation.setUsagesString(usagesString);
        String title = FindBundle.message("find.usages.of.element.in.scope.panel.title", usagesString, UsageViewUtil.getLongName(psiElement), scopeString);
        presentation.setTabText(title);
        presentation.setTabName(FindBundle.message("find.usages.of.element.tab.name", usagesString, UsageViewUtil.getShortName(psiElement)));
        presentation.setTargetsNodeText(StringUtil.capitalize((String)UsageViewUtil.getType(psiElement)));
        presentation.setOpenInNewTab(toOpenInNewTab);
        UsageViewPresentation usageViewPresentation = presentation;
        if (usageViewPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesManager", "createPresentation"));
        }
        return usageViewPresentation;
    }

    private void findUsagesInEditor(@NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements, @NotNull FindUsagesHandler handler2, @NotNull PsiFile scopeFile, @NotNull FileSearchScope direction, @NotNull FindUsagesOptions findUsagesOptions, @NotNull FileEditor fileEditor) {
        if (primaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/find/findUsages/FindUsagesManager", "findUsagesInEditor"));
        }
        if (secondaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryElements", "com/intellij/find/findUsages/FindUsagesManager", "findUsagesInEditor"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "findUsagesInEditor"));
        }
        if (scopeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFile", "com/intellij/find/findUsages/FindUsagesManager", "findUsagesInEditor"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/intellij/find/findUsages/FindUsagesManager", "findUsagesInEditor"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "findUsagesInEditor"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/find/findUsages/FindUsagesManager", "findUsagesInEditor"));
        }
        this.initLastSearchElement(findUsagesOptions, primaryElements, secondaryElements);
        this.clearStatusBar();
        FileEditorLocation currentLocation = fileEditor.getCurrentLocation();
        PsiElement2UsageTargetAdapter[] primaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements);
        PsiElement2UsageTargetAdapter[] secondaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements);
        UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, scopeFile);
        AtomicBoolean usagesWereFound = new AtomicBoolean();
        Usage fUsage = FindUsagesManager.findSiblingUsage(usageSearcher, direction, currentLocation, usagesWereFound, fileEditor);
        if (fUsage != null) {
            fUsage.navigate(true);
            fUsage.selectInEditor();
        } else if (!usagesWereFound.get()) {
            String message = FindUsagesManager.getNoUsagesFoundMessage(primaryElements[0]) + " in " + scopeFile.getName();
            this.showHintOrStatusBarMessage(message, fileEditor);
        } else {
            fileEditor.putUserData(KEY_START_USAGE_AGAIN, (Object)VALUE_START_USAGE_AGAIN);
            this.showHintOrStatusBarMessage(FindUsagesManager.getSearchAgainMessage(primaryElements[0], direction), fileEditor);
        }
    }

    private static String getNoUsagesFoundMessage(PsiElement psiElement) {
        String elementType = UsageViewUtil.getType(psiElement);
        String elementName = UsageViewUtil.getShortName(psiElement);
        return FindBundle.message("find.usages.of.element_type.element_name.not.found.message", elementType, elementName);
    }

    private void clearStatusBar() {
        StatusBar.Info.set((String)"", (Project)this.myProject);
    }

    private static String getSearchAgainMessage(PsiElement element, FileSearchScope direction) {
        String shortcutsText;
        AnAction action;
        String shortcutsText2;
        String message = FindUsagesManager.getNoUsagesFoundMessage(element);
        message = direction == FileSearchScope.AFTER_CARET ? ((shortcutsText2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action = ActionManager.getInstance().getAction("FindNext")))).isEmpty() ? FindBundle.message("find.search.again.from.top.action.message", message) : FindBundle.message("find.search.again.from.top.hotkey.message", message, shortcutsText2)) : ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("FindPrevious"))).isEmpty() ? FindBundle.message("find.search.again.from.bottom.action.message", message) : FindBundle.message("find.search.again.from.bottom.hotkey.message", message, shortcutsText));
        return message;
    }

    private void showHintOrStatusBarMessage(String message, FileEditor fileEditor) {
        if (fileEditor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)fileEditor;
            FindUsagesManager.showEditorHint(message, textEditor.getEditor());
        } else {
            StatusBar.Info.set((String)message, (Project)this.myProject);
        }
    }

    private static Usage findSiblingUsage(@NotNull UsageSearcher usageSearcher, @NotNull FileSearchScope dir, FileEditorLocation currentLocation, @NotNull AtomicBoolean usagesWereFound, @NotNull FileEditor fileEditor) {
        if (usageSearcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageSearcher", "com/intellij/find/findUsages/FindUsagesManager", "findSiblingUsage"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/find/findUsages/FindUsagesManager", "findSiblingUsage"));
        }
        if (usagesWereFound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usagesWereFound", "com/intellij/find/findUsages/FindUsagesManager", "findSiblingUsage"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/find/findUsages/FindUsagesManager", "findSiblingUsage"));
        }
        if (fileEditor.getUserData(KEY_START_USAGE_AGAIN) != null) {
            dir = dir == FileSearchScope.AFTER_CARET ? FileSearchScope.FROM_START : FileSearchScope.FROM_END;
        }
        FileSearchScope direction = dir;
        AtomicReference foundUsage = new AtomicReference();
        usageSearcher.generate(usage -> {
            block6: {
                Usage found;
                block7: {
                    block5: {
                        if (usagesWereFound == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usagesWereFound", "com/intellij/find/findUsages/FindUsagesManager", "lambda$findSiblingUsage$12"));
                        }
                        usagesWereFound.set(true);
                        if (direction == FileSearchScope.FROM_START) {
                            foundUsage.compareAndSet(null, usage);
                            return false;
                        }
                        if (direction != FileSearchScope.FROM_END) break block5;
                        foundUsage.set(usage);
                        break block6;
                    }
                    if (direction != FileSearchScope.AFTER_CARET) break block7;
                    if (Comparing.compare((Comparable)usage.getLocation(), (Comparable)currentLocation) > 0) {
                        foundUsage.set(usage);
                        return false;
                    }
                    break block6;
                }
                if (direction != FileSearchScope.BEFORE_CARET) break block6;
                if (Comparing.compare((Comparable)usage.getLocation(), (Comparable)currentLocation) >= 0) {
                    return false;
                }
                while (!((found = (Usage)foundUsage.get()) == null ? foundUsage.compareAndSet(null, usage) : Comparing.compare((Comparable)found.getLocation(), (Comparable)usage.getLocation()) < 0 && foundUsage.compareAndSet(found, usage))) {
                }
            }
            return true;
        });
        fileEditor.putUserData(KEY_START_USAGE_AGAIN, null);
        return (Usage)foundUsage.get();
    }

    private static PsiElement2UsageTargetAdapter convertToUsageTarget(@NotNull PsiElement elementToSearch, @NotNull FindUsagesOptions findUsagesOptions) {
        if (elementToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToSearch", "com/intellij/find/findUsages/FindUsagesManager", "convertToUsageTarget"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "convertToUsageTarget"));
        }
        if (elementToSearch instanceof NavigationItem) {
            return new PsiElement2UsageTargetAdapter(elementToSearch, findUsagesOptions);
        }
        throw new IllegalArgumentException("Wrong usage target:" + elementToSearch + "; " + elementToSearch.getClass());
    }

    @NotNull
    private static String generateUsagesString(@NotNull FindUsagesOptions selectedOptions) {
        if (selectedOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedOptions", "com/intellij/find/findUsages/FindUsagesManager", "generateUsagesString"));
        }
        String string = selectedOptions.generateUsagesString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesManager", "generateUsagesString"));
        }
        return string;
    }

    private static void showEditorHint(String message, Editor editor) {
        JComponent component = HintUtil.createInformationLabel(message);
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
    }

    public static String getHelpID(PsiElement element) {
        return ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(element.getLanguage())).getHelpId(element);
    }

    public void rerunAndRecallFromHistory(@NotNull ConfigurableUsageTarget usageTarget) {
        if (usageTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageTarget", "com/intellij/find/findUsages/FindUsagesManager", "rerunAndRecallFromHistory"));
        }
        usageTarget.findUsages();
        this.addToHistory(usageTarget);
    }

    public void addToHistory(@NotNull ConfigurableUsageTarget usageTarget) {
        if (usageTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageTarget", "com/intellij/find/findUsages/FindUsagesManager", "addToHistory"));
        }
        this.myHistory.add(usageTarget);
    }

    @NotNull
    public UsageHistory getHistory() {
        UsageHistory usageHistory = this.myHistory;
        if (usageHistory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesManager", "getHistory"));
        }
        return usageHistory;
    }

    @NotNull
    public static GlobalSearchScope getMaximalScope(@NotNull FindUsagesHandler handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "getMaximalScope"));
        }
        PsiElement element = handler2.getPsiElement();
        Project project2 = element.getProject();
        PsiFile file2 = element.getContainingFile();
        if (file2 != null && ProjectFileIndex.SERVICE.getInstance((Project)project2).isInContent(file2.getViewProvider().getVirtualFile())) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project2);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesManager", "getMaximalScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project2);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesManager", "getMaximalScope"));
        }
        return globalSearchScope;
    }

    private static /* synthetic */ UsageSearcher lambda$doFindUsages$11(PsiElement2UsageTargetAdapter[] primaryTargets, PsiElement2UsageTargetAdapter[] secondaryTargets, @NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions findUsagesOptions) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindUsagesManager", "lambda$doFindUsages$11"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindUsagesManager", "lambda$doFindUsages$11"));
        }
        return FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, null);
    }

    private static /* synthetic */ boolean lambda$null$8(Processor usageInfoProcessor, PsiReference ref) {
        UsageInfo info = (UsageInfo)ReadAction.compute(() -> {
            if (!ref.getElement().isValid()) {
                return null;
            }
            return new UsageInfo(ref);
        });
        return info == null || usageInfoProcessor.process((Object)info);
    }

    private static enum FileSearchScope {
        FROM_START,
        FROM_END,
        AFTER_CARET,
        BEFORE_CARET;

    }
}

