/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class BlockIndentOptions {
    private final CodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;
    private final int myRightMargin;

    public BlockIndentOptions(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, Block block) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/formatting/engine/BlockIndentOptions", "<init>"));
        }
        if (indentOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentOptions", "com/intellij/formatting/engine/BlockIndentOptions", "<init>"));
        }
        this.mySettings = settings;
        this.myIndentOptions = indentOptions;
        this.myRightMargin = this.calcRightMargin(block);
    }

    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        return this.myIndentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull AbstractBlockWrapper block) {
        CommonCodeStyleSettings.IndentOptions result2;
        CommonCodeStyleSettings commonSettings;
        Language language;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/engine/BlockIndentOptions", "getIndentOptions"));
        }
        if (!this.myIndentOptions.isOverrideLanguageOptions() && (language = block.getLanguage()) != null && (commonSettings = this.mySettings.getCommonSettings(language)) != null && (result2 = commonSettings.getIndentOptions()) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = result2;
            if (indentOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/engine/BlockIndentOptions", "getIndentOptions"));
            }
            return indentOptions;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = this.myIndentOptions;
        if (indentOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/engine/BlockIndentOptions", "getIndentOptions"));
        }
        return indentOptions;
    }

    public int getRightMargin() {
        return this.myRightMargin;
    }

    private int calcRightMargin(Block rootBlock) {
        PsiFile psiFile;
        PsiElement psiElement;
        ASTNode node;
        Language language = null;
        if (rootBlock instanceof ASTBlock && (node = ((ASTBlock)rootBlock).getNode()) != null && (psiElement = node.getPsi()).isValid() && (psiFile = psiElement.getContainingFile()) != null) {
            language = psiFile.getViewProvider().getBaseLanguage();
        }
        return this.mySettings.getRightMargin(language);
    }
}

