/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.patches;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PatchCreator {
    public static void create(Project p, List<Change> changes, String filePath, boolean isReverse, CommitContext commitContext) throws IOException, VcsException {
        PatchCreator.create(p, (String)ObjectUtils.assertNotNull((Object)p.getBasePath()), changes, filePath, isReverse, commitContext, Charset.defaultCharset());
    }

    public static void create(Project p, @NotNull String basePath, List<Change> changes, String filePath, boolean isReverse, CommitContext commitContext, Charset charset) throws IOException, VcsException {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/history/integration/patches/PatchCreator", "create"));
        }
        List<FilePatch> patches = IdeaTextPatchBuilder.buildPatch(p, changes, basePath, isReverse);
        PatchWriter.writePatches(p, filePath, basePath, patches, commitContext, charset);
    }
}

