/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.UI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AboutPopup {
    private static final String COPY_URL = "copy://";
    private static JBPopup ourPopup;

    public static void show(@Nullable Window window, boolean showDebugInfo) {
        RelativePoint location;
        ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
        PopupPanel panel2 = new PopupPanel(new BorderLayout());
        Icon image = IconLoader.getIcon((String)appInfo.getAboutImageUrl());
        if (appInfo.showLicenseeInfo()) {
            InfoSurface infoSurface = new InfoSurface(image, showDebugInfo);
            infoSurface.setPreferredSize(new Dimension(image.getIconWidth(), image.getIconHeight()));
            panel2.setInfoSurface(infoSurface);
        } else {
            panel2.add((Component)new JLabel(image), "North");
        }
        if (window != null) {
            Rectangle r = window.getBounds();
            location = new RelativePoint((Component)window, new Point((r.width - image.getIconWidth()) / 2, (r.height - image.getIconHeight()) / 2));
        } else {
            Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            location = new RelativePoint(new Point((r.width - image.getIconWidth()) / 2, (r.height - image.getIconHeight()) / 2));
        }
        ourPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)panel2).setRequestFocus(true).setFocusable(true).setResizable(false).setMovable(false).setModalContext(false).setShowShadow(true).setShowBorder(false).setCancelKeyEnabled(true).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).createPopup();
        Disposer.register((Disposable)ourPopup, (Disposable)new Disposable(){

            public void dispose() {
                ourPopup = null;
            }
        });
        ourPopup.show(location);
    }

    private static void copyInfoToClipboard(String text) {
        try {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class PopupPanel
    extends JPanel {
        private InfoSurface myInfoSurface;

        public PopupPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePopupPanel();
            }
            return this.accessibleContext;
        }

        public void setInfoSurface(InfoSurface infoSurface) {
            this.myInfoSurface = infoSurface;
            this.add((Component)infoSurface, "North");
            new DumbAwareAction(){

                public void actionPerformed(AnActionEvent e) {
                    AboutPopup.copyInfoToClipboard(myInfoSurface.getText());
                }
            }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"meta C", "control C"}), (JComponent)this);
        }

        protected class AccessiblePopupPanel
        extends JPanel.AccessibleJPanel
        implements AccessibleAction {
            protected AccessiblePopupPanel() {
                super(PopupPanel.this);
            }

            @Override
            public String getAccessibleName() {
                ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
                return "About " + appInfo.getFullApplicationName();
            }

            @Override
            public String getAccessibleDescription() {
                if (PopupPanel.this.myInfoSurface != null) {
                    return "Press Copy key to copy system information to clipboard";
                }
                return null;
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this;
            }

            @Override
            public int getAccessibleActionCount() {
                if (PopupPanel.this.myInfoSurface != null) {
                    return 1;
                }
                return 0;
            }

            @Override
            public String getAccessibleActionDescription(int i2) {
                if (i2 == 0 && PopupPanel.this.myInfoSurface != null) {
                    return "Copy system information to clipboard";
                }
                return null;
            }

            @Override
            public boolean doAccessibleAction(int i2) {
                if (i2 == 0 && PopupPanel.this.myInfoSurface != null) {
                    AboutPopup.copyInfoToClipboard(PopupPanel.this.myInfoSurface.getText());
                    return true;
                }
                return false;
            }
        }
    }

    private static class InfoSurface
    extends JPanel {
        private final Color myColor;
        private final Color myLinkColor;
        private final Icon myImage;
        private final boolean myShowDebugInfo;
        private Font myFont;
        private Font myBoldFont;
        private final List<AboutBoxLine> myLines = new ArrayList<AboutBoxLine>();
        private StringBuilder myInfo = new StringBuilder();
        private final List<Link> myLinks = new ArrayList<Link>();
        private Link myActiveLink;
        private boolean myShowCopy = false;
        private float myShowCopyAlpha;
        private Alarm myAlarm = new Alarm();

        public InfoSurface(Icon image, boolean showDebugInfo) {
            ApplicationInfoImpl appInfo = (ApplicationInfoImpl)ApplicationInfoEx.getInstanceEx();
            this.myImage = image;
            this.myColor = Color.white;
            this.myLinkColor = appInfo.getAboutLinkColor() != null ? appInfo.getAboutLinkColor() : UI.getColor((String)"link.foreground");
            this.myShowDebugInfo = showDebugInfo;
            this.setOpaque(false);
            this.setBackground(this.myColor);
            this.setFocusable(true);
            Calendar cal = appInfo.getBuildDate();
            this.myLines.add(new AboutBoxLine(appInfo.getFullApplicationName(), true, null));
            this.appendLast();
            String buildInfo = IdeBundle.message((String)"about.box.build.number", (Object[])new Object[]{appInfo.getBuild().asString()});
            String buildDate = "";
            if (appInfo.getBuild().isSnapshot()) {
                buildDate = new SimpleDateFormat("HH:mm, ").format(cal.getTime());
            }
            buildDate = buildDate + DateFormatUtil.formatAboutDialogDate((Date)cal.getTime());
            buildInfo = buildInfo + IdeBundle.message((String)"about.box.build.date", (Object[])new Object[]{buildDate});
            this.myLines.add(new AboutBoxLine(buildInfo));
            this.appendLast();
            this.myLines.add(new AboutBoxLine(""));
            LicensingFacade provider = LicensingFacade.getInstance();
            if (provider != null) {
                this.myLines.add(new AboutBoxLine(provider.getLicensedToMessage(), true, null));
                this.appendLast();
                for (String message : provider.getLicenseRestrictionsMessages()) {
                    this.myLines.add(new AboutBoxLine(message));
                    this.appendLast();
                }
            }
            this.myLines.add(new AboutBoxLine(""));
            Properties properties = System.getProperties();
            String javaVersion = properties.getProperty("java.runtime.version", properties.getProperty("java.version", "unknown"));
            String arch = properties.getProperty("os.arch", "");
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"about.box.jre", (Object[])new Object[]{javaVersion, arch})));
            this.appendLast();
            String vmVersion = properties.getProperty("java.vm.name", "unknown");
            String vmVendor = properties.getProperty("java.vendor", "unknown");
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"about.box.vm", (Object[])new Object[]{vmVersion, vmVendor})));
            this.appendLast();
            String thirdParty = appInfo.getThirdPartySoftwareURL();
            if (thirdParty != null) {
                this.myLines.add(new AboutBoxLine(""));
                this.myLines.add(new AboutBoxLine(""));
                this.myLines.add(new AboutBoxLine("Powered by ").keepWithNext());
                this.myLines.add(new AboutBoxLine("open-source software", false, thirdParty));
            }
            this.addMouseListener(new MouseAdapter(){
                static final double maxAlpha = 0.5;
                static final double fadeStep = 0.05;
                static final int animationDelay = 15;

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (myActiveLink != null) {
                        event.consume();
                        if (AboutPopup.COPY_URL.equals(myActiveLink.myUrl)) {
                            AboutPopup.copyInfoToClipboard(this.getText());
                            if (ourPopup != null) {
                                ourPopup.cancel();
                            }
                            return;
                        }
                        BrowserUtil.browse((String)myActiveLink.myUrl);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!myShowCopy) {
                        myShowCopy = true;
                        myAlarm.cancelAllRequests();
                        myAlarm.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                if ((double)myShowCopyAlpha < 0.5) {
                                    myShowCopyAlpha = (float)((double)myShowCopyAlpha + 0.05);
                                    this.repaint();
                                    myAlarm.addRequest((Runnable)this, 15);
                                }
                            }
                        }, 15);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (myShowCopy) {
                        myShowCopy = false;
                        myAlarm.cancelAllRequests();
                        myAlarm.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                if (myShowCopyAlpha > 0.0f) {
                                    myShowCopyAlpha = (float)((double)myShowCopyAlpha - 0.05);
                                    this.repaint();
                                    myAlarm.addRequest((Runnable)this, 15);
                                }
                            }
                        }, 15);
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent event) {
                    boolean hadLink = myActiveLink != null;
                    myActiveLink = null;
                    for (Link link : myLinks) {
                        if (!link.myRectangle.contains(event.getPoint())) continue;
                        myActiveLink = link;
                        if (hadLink) break;
                        this.setCursor(Cursor.getPredefinedCursor(12));
                        break;
                    }
                    if (hadLink && myActiveLink == null) {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
        }

        private void appendLast() {
            this.myInfo.append(this.myLines.get(this.myLines.size() - 1).getText()).append("\n");
        }

        @Override
        protected void paintChildren(Graphics g) {
            ApplicationInfo appInfo;
            Rectangle aboutLogoRect;
            super.paintChildren(g);
            Graphics2D g2 = (Graphics2D)g;
            UISettings.setupAntialiasing((Graphics)g);
            JBFont labelFont = JBUI.Fonts.label();
            if (SystemInfo.isWindows) {
                labelFont = JBUI.Fonts.create((String)"Tahoma", (int)12);
            }
            int startFontSize = Registry.is((String)"ide.new.about") ? 14 : 10;
            for (int labelSize = JBUI.scale((int)startFontSize); labelSize != JBUI.scale((int)6); --labelSize) {
                this.myLinks.clear();
                g2.setPaint(this.myColor);
                this.myImage.paintIcon(this, g2, 0, 0);
                g2.setColor(this.myColor);
                TextRenderer renderer = this.createTextRenderer(g2);
                UIUtil.setupComposite((Graphics2D)g2);
                this.myFont = labelFont.deriveFont(0, labelSize);
                this.myBoldFont = labelFont.deriveFont(1, labelSize + 1);
                try {
                    renderer.render(30, 0, this.myLines);
                    break;
                }
                catch (TextRenderer.OverflowException overflowException) {
                    continue;
                }
            }
            if ((aboutLogoRect = (appInfo = ApplicationInfo.getInstance()).getAboutLogoRect()) != null) {
                this.myLinks.add(new Link(aboutLogoRect, appInfo.getCompanyURL()));
            }
            if (appInfo instanceof ApplicationInfoImpl) {
                g2.setColor(((ApplicationInfoImpl)appInfo).getCopyrightForeground());
                if (SystemInfo.isMac) {
                    g2.setFont((Font)JBUI.Fonts.miniFont());
                } else {
                    g2.setFont((Font)JBUI.Fonts.create((String)"Tahoma", (int)10));
                }
            } else {
                g2.setColor((Color)JBColor.BLACK);
            }
            if (Registry.is((String)"ide.new.about")) {
                g2.setColor((Color)Gray.x33);
                g2.setFont((Font)JBUI.Fonts.label((float)12.0f));
            }
            int copyrightX = Registry.is((String)"ide.new.about") ? JBUI.scale((int)140) : JBUI.scale((int)30);
            int copyrightY = Registry.is((String)"ide.new.about") ? JBUI.scale((int)390) : JBUI.scale((int)284);
            g2.drawString(this.getCopyrightText(), copyrightX, copyrightY);
            if (this.myShowDebugInfo) {
                g2.setColor(((ApplicationInfoEx)appInfo).getAboutForeground());
                for (Link link : this.myLinks) {
                    g2.drawRect(((Link)link).myRectangle.x, ((Link)link).myRectangle.y, ((Link)link).myRectangle.width, ((Link)link).myRectangle.height);
                }
            }
        }

        @NotNull
        private String getCopyrightText() {
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            String string = "\u00a9 2000\u2013" + Calendar.getInstance(Locale.US).get(1) + " JetBrains s.r.o. All rights reserved.";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/AboutPopup$InfoSurface", "getCopyrightText"));
            }
            return string;
        }

        @NotNull
        private TextRenderer createTextRenderer(Graphics2D g) {
            if (Registry.is((String)"ide.new.about")) {
                TextRenderer textRenderer = new TextRenderer(18, 200, 500, 220, g);
                if (textRenderer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/AboutPopup$InfoSurface", "createTextRenderer"));
                }
                return textRenderer;
            }
            TextRenderer textRenderer = new TextRenderer(0, 165, 398, 120, g);
            if (textRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/AboutPopup$InfoSurface", "createTextRenderer"));
            }
            return textRenderer;
        }

        public String getText() {
            return this.myInfo.toString() + SystemInfo.getOsNameAndVersion();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleInfoSurface();
            }
            return this.accessibleContext;
        }

        protected class AccessibleInfoSurface
        extends JPanel.AccessibleJPanel {
            protected AccessibleInfoSurface() {
                super(InfoSurface.this);
            }

            @Override
            public String getAccessibleName() {
                String text = "System Information\n" + InfoSurface.this.getText() + "\n" + InfoSurface.this.getCopyrightText();
                return AccessibleContextUtil.replaceLineSeparatorsWithPunctuation((String)text);
            }
        }

        private static class Link {
            private final Rectangle myRectangle;
            private final String myUrl;

            private Link(Rectangle rectangle, String url) {
                this.myRectangle = rectangle;
                this.myUrl = url;
            }
        }

        private static class AboutBoxLine {
            private final String myText;
            private final boolean myBold;
            private final String myUrl;
            private boolean myKeepWithNext;

            public AboutBoxLine(String text, boolean bold, String url) {
                this.myText = text;
                this.myBold = bold;
                this.myUrl = url;
            }

            public AboutBoxLine(String text) {
                this.myText = text;
                this.myBold = false;
                this.myUrl = null;
            }

            public String getText() {
                return this.myText;
            }

            public boolean isBold() {
                return this.myBold;
            }

            public String getUrl() {
                return this.myUrl;
            }

            public boolean isKeepWithNext() {
                return this.myKeepWithNext;
            }

            public AboutBoxLine keepWithNext() {
                this.myKeepWithNext = true;
                return this;
            }
        }

        private class TextRenderer {
            private final int xBase;
            private final int yBase;
            private final int w;
            private final int h;
            private final Graphics2D g2;
            private int x = 0;
            private int y = 0;
            private FontMetrics fontmetrics;
            private int fontAscent;
            private int fontHeight;
            private Font font;

            public TextRenderer(int xBase, int yBase, int w, int h, Graphics2D g2) {
                this.xBase = JBUI.scale((int)xBase);
                this.yBase = JBUI.scale((int)yBase);
                this.w = JBUI.scale((int)w);
                this.h = JBUI.scale((int)h);
                this.g2 = g2;
                if (SystemInfo.isWindows) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
            }

            public void render(int indentX, int indentY, List<AboutBoxLine> lines) throws OverflowException {
                this.x = indentX;
                this.y = indentY;
                ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
                boolean showCopyButton = InfoSurface.this.myShowCopy || InfoSurface.this.myShowCopyAlpha > 0.0f;
                for (AboutBoxLine line : lines) {
                    FontMetrics metrics;
                    String s = line.getText();
                    this.setFont(line.isBold() ? InfoSurface.this.myBoldFont : InfoSurface.this.myFont);
                    if (line.getUrl() != null) {
                        this.g2.setColor(InfoSurface.this.myLinkColor);
                        metrics = this.g2.getFontMetrics(this.font);
                        InfoSurface.this.myLinks.add(new Link(new Rectangle(this.xBase + this.x, this.yBase + this.y - this.fontAscent, metrics.stringWidth(s + " "), this.fontHeight), line.getUrl()));
                    } else {
                        this.g2.setColor((Color)(Registry.is((String)"ide.new.about") ? Gray.x33 : appInfo.getAboutForeground()));
                    }
                    this.renderString(s, indentX);
                    if (showCopyButton) {
                        metrics = this.g2.getFontMetrics(InfoSurface.this.myFont);
                        String copyString = "Copy to Clipboard";
                        int width = metrics.stringWidth(copyString);
                        this.g2.setFont(InfoSurface.this.myFont);
                        this.g2.setColor(InfoSurface.this.myLinkColor);
                        int xOffset = InfoSurface.this.myImage.getIconWidth() - width - 10;
                        GraphicsConfig config = GraphicsUtil.paintWithAlpha((Graphics)this.g2, (float)Math.max(0.0f, Math.min(1.0f, InfoSurface.this.myShowCopyAlpha)));
                        this.g2.drawString(copyString, xOffset, this.yBase + this.y);
                        config.restore();
                        InfoSurface.this.myLinks.add(new Link(new Rectangle(xOffset, this.yBase + this.y - this.fontAscent, width, this.fontHeight), AboutPopup.COPY_URL));
                        showCopyButton = false;
                    }
                    if (line.isKeepWithNext() || line.equals(lines.get(lines.size() - 1))) continue;
                    this.lineFeed(indentX, s);
                }
            }

            private void renderString(String s, int indentX) throws OverflowException {
                List words = StringUtil.split((String)s, (String)" ");
                for (String word : words) {
                    int wordWidth = this.fontmetrics.stringWidth(word);
                    if (this.x + wordWidth >= this.w) {
                        this.lineFeed(indentX, word);
                    } else {
                        char c = ' ';
                        int cW = this.fontmetrics.charWidth(c);
                        if (this.x + cW < this.w) {
                            this.g2.drawChars(new char[]{c}, 0, 1, this.xBase + this.x, this.yBase + this.y);
                            this.x += cW;
                        }
                    }
                    this.renderWord(word, indentX);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void renderWord(String s, int indentX) throws OverflowException {
                for (int j = 0; j != s.length(); ++j) {
                    char c = s.charAt(j);
                    Font f = null;
                    FontMetrics fm = null;
                    try {
                        int cW;
                        if (!this.g2.getFont().canDisplay(c)) {
                            f = this.g2.getFont();
                            fm = this.fontmetrics;
                            this.g2.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
                            this.fontmetrics = this.g2.getFontMetrics();
                        }
                        if (this.x + (cW = this.fontmetrics.charWidth(c)) >= this.w) {
                            this.lineFeed(indentX, s);
                        }
                        this.g2.drawChars(new char[]{c}, 0, 1, this.xBase + this.x, this.yBase + this.y);
                        this.x += cW;
                        if (f == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (f != null) {
                            this.g2.setFont(f);
                            this.fontmetrics = fm;
                        }
                        throw throwable;
                    }
                    this.g2.setFont(f);
                    this.fontmetrics = fm;
                }
            }

            private void lineFeed(int indent, String s) throws OverflowException {
                this.x = indent;
                this.y = s.length() == 0 ? (this.y += this.fontHeight / 3) : (this.y += this.fontHeight);
                if (this.y >= this.h) {
                    throw new OverflowException();
                }
            }

            private void setFont(Font font) {
                this.font = font;
                this.fontmetrics = this.g2.getFontMetrics(font);
                this.g2.setFont(font);
                this.fontAscent = this.fontmetrics.getAscent();
                this.fontHeight = this.fontmetrics.getHeight();
            }

            public class OverflowException
            extends Exception {
            }
        }
    }
}

