/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.content.Content;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ActivateToolWindowAction
extends DumbAwareAction {
    private final String myToolWindowId;

    private ActivateToolWindowAction(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/ide/actions/ActivateToolWindowAction", "<init>"));
        }
        this.myToolWindowId = toolWindowId;
    }

    @NotNull
    public String getToolWindowId() {
        String string = this.myToolWindowId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ActivateToolWindowAction", "getToolWindowId"));
        }
        return string;
    }

    public static void ensureToolWindowActionRegistered(@NotNull ToolWindowImpl toolWindow) {
        String actionId;
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/actions/ActivateToolWindowAction", "ensureToolWindowActionRegistered"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction(actionId = ActivateToolWindowAction.getActionIdForToolWindow(toolWindow.getId()));
        if (action == null) {
            ActivateToolWindowAction newAction = new ActivateToolWindowAction(toolWindow.getId());
            newAction.updatePresentation(newAction.getTemplatePresentation(), toolWindow);
            actionManager.registerAction(actionId, (AnAction)newAction);
        }
    }

    public static void updateToolWindowActionPresentation(@NotNull ToolWindowImpl toolWindow) {
        String actionId;
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/actions/ActivateToolWindowAction", "updateToolWindowActionPresentation"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction(actionId = ActivateToolWindowAction.getActionIdForToolWindow(toolWindow.getId()));
        if (action instanceof ActivateToolWindowAction) {
            ((ActivateToolWindowAction)action).updatePresentation(action.getTemplatePresentation(), toolWindow);
        }
    }

    public void update(AnActionEvent e) {
        Project project2 = ActivateToolWindowAction.getEventProject((AnActionEvent)e);
        Presentation presentation = e.getPresentation();
        if (project2 == null || project2.isDisposed()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(this.myToolWindowId);
        if (toolWindow == null) {
            presentation.setEnabledAndVisible(false);
        } else {
            presentation.setVisible(true);
            presentation.setEnabled(toolWindow.isAvailable());
            this.updatePresentation(presentation, toolWindow);
        }
    }

    private void updatePresentation(@NotNull Presentation presentation, @NotNull ToolWindow toolWindow) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/ide/actions/ActivateToolWindowAction", "updatePresentation"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/actions/ActivateToolWindowAction", "updatePresentation"));
        }
        String title = toolWindow.getStripeTitle();
        presentation.setText(title);
        presentation.setDescription(IdeBundle.message((String)"action.activate.tool.window", (Object[])new Object[]{title}));
        Icon icon = toolWindow.getIcon();
        if ("Event Log".equals(this.myToolWindowId)) {
            icon = AllIcons.Ide.Notification.InfoEvents;
        }
        presentation.setIcon((Icon)(icon == null ? null : new SizedIcon(icon, icon.getIconHeight(), icon.getIconHeight())));
    }

    public void actionPerformed(AnActionEvent e) {
        Content[] contents;
        Project project2 = ActivateToolWindowAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project2);
        ToolWindow window = windowManager.getToolWindow(this.myToolWindowId);
        InputEvent event = e.getInputEvent();
        Runnable run2 = null;
        if (event instanceof KeyEvent && event.isShiftDown() && (contents = window.getContentManager().getContents()).length > 0 && window.getContentManager().getSelectedContent() != contents[0]) {
            run2 = () -> window.getContentManager().setSelectedContent(contents[0], true, true);
        }
        if (windowManager.isEditorComponentActive() || !this.myToolWindowId.equals(windowManager.getActiveToolWindowId()) || run2 != null) {
            if (run2 != null && window.isActive()) {
                run2.run();
            } else {
                window.activate(run2);
            }
        } else {
            windowManager.getToolWindow(this.myToolWindowId).hide(null);
        }
    }

    @NonNls
    public static String getActionIdForToolWindow(String id) {
        return "Activate" + id.replaceAll(" ", "") + "ToolWindow";
    }

    public static int getMnemonicForToolWindow(String id) {
        Shortcut[] shortcuts;
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        for (Shortcut shortcut : shortcuts = activeKeymap.getShortcuts(ActivateToolWindowAction.getActionIdForToolWindow(id))) {
            int keyCode;
            KeyStroke keyStroke;
            int modifiers;
            if (!(shortcut instanceof KeyboardShortcut) || (modifiers = (keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke()).getModifiers()) != 520 && modifiers != 8 && modifiers != 512 && modifiers != 260 && modifiers != 4 && modifiers != 256 || 48 > (keyCode = keyStroke.getKeyCode()) || keyCode > 57) continue;
            char c = (char)(48 + keyCode - 48);
            return c;
        }
        return -1;
    }
}

