/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;

public class SaveAllAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/SaveAllAction", "actionPerformed"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor != null) {
            SaveAllAction.stripSpacesFromCaretLines(editor);
        }
        ApplicationManager.getApplication().saveAll();
    }

    private static void stripSpacesFromCaretLines(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/actions/SaveAllAction", "stripSpacesFromCaretLines"));
        }
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        if (!"None".equals(editorSettings.getStripTrailingSpaces()) && !editorSettings.isKeepTrailingSpacesOnCaretLine()) {
            Document document = editor.getDocument();
            boolean inChangedLinesOnly = "Changed".equals(editorSettings.getStripTrailingSpaces());
            TrailingSpacesStripper.strip(document, inChangedLinesOnly, false);
        }
    }
}

