/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableErrorTreeElement;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigatableMessageElement
extends ErrorTreeElement
implements NavigatableErrorTreeElement {
    private final GroupingElement myParent;
    private final String[] myMessage;
    @NotNull
    private final Navigatable myNavigatable;
    private final String myExportText;
    private final String myRendererTextPrefix;

    public NavigatableMessageElement(@NotNull ErrorTreeElementKind kind, @Nullable GroupingElement parent, String[] message, @NotNull Navigatable navigatable, String exportText, String rendererTextPrefix) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/ide/errorTreeView/NavigatableMessageElement", "<init>"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/ide/errorTreeView/NavigatableMessageElement", "<init>"));
        }
        super(kind);
        this.myParent = parent;
        this.myMessage = message;
        this.myNavigatable = navigatable;
        this.myExportText = exportText;
        this.myRendererTextPrefix = rendererTextPrefix;
    }

    @Override
    @NotNull
    public Navigatable getNavigatable() {
        Navigatable navigatable = this.myNavigatable;
        if (navigatable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/NavigatableMessageElement", "getNavigatable"));
        }
        return navigatable;
    }

    @Override
    public String[] getText() {
        return this.myMessage;
    }

    @Override
    public Object getData() {
        return this.myParent.getData();
    }

    @Nullable
    public GroupingElement getParent() {
        return this.myParent;
    }

    @Override
    public String getExportTextPrefix() {
        return this.getKind().getPresentableText() + this.myExportText;
    }

    public String getRendererTextPrefix() {
        return this.myRendererTextPrefix;
    }
}

