/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;

public class AddAllOpenFilesToFavorites
extends AnAction
implements DumbAware {
    private final String myFavoritesName;

    public AddAllOpenFilesToFavorites(String chosenList) {
        this.getTemplatePresentation().setText(chosenList, false);
        this.myFavoritesName = chosenList;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        ArrayList<PsiFile> filesToAdd = AddAllOpenFilesToFavorites.getFilesToAdd(project2);
        for (PsiFile file2 : filesToAdd) {
            favoritesManager.addRoots(this.myFavoritesName, null, file2);
        }
    }

    static ArrayList<PsiFile> getFilesToAdd(Project project2) {
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project2);
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        for (VirtualFile openFile2 : editorManager.getOpenFiles()) {
            PsiFile psiFile;
            if (!openFile2.isValid() || (psiFile = psiManager.findFile(openFile2)) == null) continue;
            result2.add(psiFile);
        }
        return result2;
    }

    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(!AddAllOpenFilesToFavorites.getFilesToAdd(project2).isEmpty());
    }
}

