/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.util.ObjectUtils;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class JavaTemplateUtil {
    public static final String TEMPLATE_CATCH_BODY = "Catch Statement Body.java";
    public static final String TEMPLATE_IMPLEMENTED_METHOD_BODY = "Implemented Method Body.java";
    public static final String TEMPLATE_OVERRIDDEN_METHOD_BODY = "Overridden Method Body.java";
    public static final String TEMPLATE_FROM_USAGE_METHOD_BODY = "New Method Body.java";
    public static final String TEMPLATE_I18NIZED_EXPRESSION = "I18nized Expression.java";
    public static final String TEMPLATE_I18NIZED_CONCATENATION = "I18nized Concatenation.java";
    public static final String TEMPLATE_I18NIZED_JSP_EXPRESSION = "I18nized JSP Expression.jsp";
    public static final String INTERNAL_CLASS_TEMPLATE_NAME = "Class";
    public static final String INTERNAL_INTERFACE_TEMPLATE_NAME = "Interface";
    public static final String INTERNAL_ANNOTATION_TYPE_TEMPLATE_NAME = "AnnotationType";
    public static final String INTERNAL_ENUM_TEMPLATE_NAME = "Enum";
    public static final String[] INTERNAL_CLASS_TEMPLATES = new String[]{"Class", "Interface", "AnnotationType", "Enum"};
    public static final String INTERNAL_PACKAGE_INFO_TEMPLATE_NAME = "package-info";
    public static final String INTERNAL_MODULE_INFO_TEMPLATE_NAME = "module-info";
    public static final String[] INTERNAL_FILE_TEMPLATES = new String[]{"package-info", "module-info"};

    private JavaTemplateUtil() {
    }

    public static void setClassAndMethodNameProperties(@NotNull Properties properties, @NotNull PsiClass aClass, @NotNull PsiMethod method2) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/fileTemplates/JavaTemplateUtil", "setClassAndMethodNameProperties"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/ide/fileTemplates/JavaTemplateUtil", "setClassAndMethodNameProperties"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ide/fileTemplates/JavaTemplateUtil", "setClassAndMethodNameProperties"));
        }
        properties.setProperty("CLASS_NAME", (String)ObjectUtils.notNull((Object)aClass.getQualifiedName(), (Object)""));
        properties.setProperty("SIMPLE_CLASS_NAME", (String)ObjectUtils.notNull((Object)aClass.getName(), (Object)""));
        properties.setProperty("METHOD_NAME", method2.getName());
    }

    @NotNull
    public static String getPackageName(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/fileTemplates/JavaTemplateUtil", "getPackageName"));
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String string = aPackage != null ? aPackage.getQualifiedName() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/JavaTemplateUtil", "getPackageName"));
        }
        return string;
    }

    public static void setPackageNameAttribute(@NotNull Properties properties, @NotNull PsiDirectory directory) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/fileTemplates/JavaTemplateUtil", "setPackageNameAttribute"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/fileTemplates/JavaTemplateUtil", "setPackageNameAttribute"));
        }
        properties.setProperty("PACKAGE_NAME", JavaTemplateUtil.getPackageName(directory));
    }
}

