/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class CreateFromTemplatePanel {
    private JPanel myMainPanel;
    private JPanel myAttrPanel;
    private JTextField myFilenameField;
    private final String[] myUnsetAttributes;
    private final ArrayList<Pair<String, JTextField>> myAttributes = new ArrayList();
    private int myHorizontalMargin = -1;
    private int myVerticalMargin = -1;
    private final boolean myMustEnterName;
    private final AttributesDefaults myAttributesDefaults;

    public CreateFromTemplatePanel(String[] unsetAttributes, boolean mustEnterName, @Nullable AttributesDefaults attributesDefaults) {
        this.myMustEnterName = mustEnterName;
        this.myUnsetAttributes = unsetAttributes;
        this.myAttributesDefaults = attributesDefaults;
    }

    public boolean hasSomethingToAsk() {
        return this.myMustEnterName || this.myUnsetAttributes.length != 0;
    }

    public JComponent getComponent() {
        if (this.myMainPanel == null) {
            this.myMainPanel = new JPanel(new GridBagLayout()){

                @Override
                public Dimension getPreferredSize() {
                    return CreateFromTemplatePanel.this.getMainPanelPreferredSize(super.getPreferredSize());
                }
            };
            this.myAttrPanel = new JPanel(new GridBagLayout());
            JPanel myScrollPanel = new JPanel(new GridBagLayout());
            this.updateShown();
            myScrollPanel.setBorder(null);
            int attrCount = this.myUnsetAttributes.length;
            if (this.myMustEnterName && !Arrays.asList(this.myUnsetAttributes).contains("NAME")) {
                ++attrCount;
            }
            Object insets = attrCount > 1 ? JBUI.insets((int)2) : new Insets(0, 0, 0, 0);
            myScrollPanel.add((Component)this.myAttrPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, (Insets)insets, 0, 0));
            if (attrCount > 1) {
                myScrollPanel.add((Component)new JPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, (Insets)JBUI.insets((int)2), 0, 0));
                JScrollPane attrScroll = ScrollPaneFactory.createScrollPane((Component)myScrollPanel, (boolean)true);
                attrScroll.setHorizontalScrollBarPolicy(31);
                attrScroll.setViewportBorder(null);
                this.myMainPanel.add((Component)attrScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insets((int)2), 0, 0));
            } else {
                this.myMainPanel.add((Component)myScrollPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        return this.myMainPanel;
    }

    public void ensureFitToScreen(int horizontalMargin, int verticalMargin) {
        this.myHorizontalMargin = horizontalMargin;
        this.myVerticalMargin = verticalMargin;
    }

    private Dimension getMainPanelPreferredSize(Dimension superPreferredSize) {
        if (this.myHorizontalMargin > 0 && this.myVerticalMargin > 0) {
            Dimension screenSize = ScreenUtil.getMainScreenBounds().getSize();
            Dimension preferredSize = superPreferredSize;
            Dimension maxSize = new Dimension(screenSize.width - this.myHorizontalMargin, screenSize.height - this.myVerticalMargin);
            int width = Math.min(preferredSize.width, maxSize.width);
            int height = Math.min(preferredSize.height, maxSize.height);
            if (height < preferredSize.height) {
                width = Math.min(width + 50, maxSize.width);
            }
            preferredSize = new Dimension(width, height);
            return preferredSize;
        }
        return superPreferredSize;
    }

    private void updateShown() {
        Insets insets = new Insets(2, 4, 4, 2);
        if (this.myMustEnterName || Arrays.asList(this.myUnsetAttributes).contains("NAME")) {
            String fileName;
            JLabel filenameLabel = new JLabel(IdeBundle.message((String)"label.file.name", (Object[])new Object[0]));
            this.myAttrPanel.add((Component)filenameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.myFilenameField = new JTextField(20);
            if (this.myAttributesDefaults != null && (fileName = this.myAttributesDefaults.getDefaultFileName()) != null) {
                int dot;
                this.myFilenameField.setText(fileName);
                Object selectionRange = this.myAttributesDefaults.getDefaultFileNameSelection() != null ? this.myAttributesDefaults.getDefaultFileNameSelection() : ((dot = fileName.indexOf(46)) > 0 ? new TextRange(0, dot) : null);
                if (selectionRange != null) {
                    CreateFromTemplatePanel.setPredefinedSelectionFor(this.myFilenameField, selectionRange);
                }
            }
            this.myAttrPanel.add((Component)this.myFilenameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        }
        int lastRow = 2;
        for (String attribute : this.myUnsetAttributes) {
            if (attribute.equals("NAME")) continue;
            JLabel label = new JLabel(attribute.replace('_', ' ') + ":");
            JTextField field = new JTextField();
            field.setColumns(30);
            if (this.myAttributesDefaults != null) {
                String defaultValue = this.myAttributesDefaults.getDefaultValueFor(attribute);
                TextRange selectionRange = this.myAttributesDefaults.getRangeFor(attribute);
                if (defaultValue != null) {
                    field.setText(defaultValue);
                    if (selectionRange != null) {
                        CreateFromTemplatePanel.setPredefinedSelectionFor(field, selectionRange);
                    }
                }
            }
            this.myAttributes.add((Pair<String, JTextField>)Pair.create((Object)attribute, (Object)field));
            this.myAttrPanel.add((Component)label, new GridBagConstraints(0, lastRow, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.myAttrPanel.add((Component)field, new GridBagConstraints(1, lastRow, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
            ++lastRow;
        }
        this.myAttrPanel.repaint();
        this.myAttrPanel.revalidate();
        this.myMainPanel.revalidate();
    }

    @Nullable
    public String getFileName() {
        if (this.myFilenameField != null) {
            String fileName = this.myFilenameField.getText();
            return fileName == null ? "" : fileName;
        }
        return null;
    }

    public Properties getProperties(Properties predefinedProperties) {
        Properties result2 = (Properties)predefinedProperties.clone();
        for (Pair<String, JTextField> pair : this.myAttributes) {
            result2.setProperty((String)pair.first, ((JTextField)pair.second).getText());
        }
        return result2;
    }

    private static void setPredefinedSelectionFor(JTextField field, TextRange selectionRange) {
        field.select(selectionRange.getStartOffset(), selectionRange.getEndOffset());
        field.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, true);
    }
}

