/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.method;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;

final class MethodHierarchyUtil {
    MethodHierarchyUtil() {
    }

    public static PsiMethod findBaseMethodInClass(PsiMethod baseMethod, PsiClass aClass, boolean checkBases) {
        if (baseMethod == null) {
            return null;
        }
        if (MethodHierarchyUtil.cannotBeOverridding(baseMethod)) {
            return null;
        }
        return MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)baseMethod, (boolean)checkBases);
    }

    private static boolean cannotBeOverridding(PsiMethod method2) {
        PsiClass parentClass = method2.getContainingClass();
        return parentClass == null || method2.isConstructor() || method2.hasModifierProperty("static") || method2.hasModifierProperty("private");
    }
}

