/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.hierarchy.type.SubtypesHierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.SupertypesHierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.type.TypeHierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeHierarchyBrowser
extends TypeHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.type.TypeHierarchyBrowser");

    public TypeHierarchyBrowser(Project project2, PsiClass psiClass) {
        super(project2, (PsiElement)psiClass);
    }

    @Override
    protected boolean isInterface(PsiElement psiElement) {
        return psiElement instanceof PsiClass && ((PsiClass)psiElement).isInterface();
    }

    @Override
    protected void createTrees(@NotNull Map<String, JTree> trees) {
        if (trees == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trees", "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser", "createTrees"));
        }
        this.createTreeAndSetupCommonActions(trees, "TypeHierarchyPopupMenu");
    }

    @Override
    protected void prependActions(DefaultActionGroup actionGroup) {
        super.prependActions(actionGroup);
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.ChangeScopeAction(){

            @Override
            protected boolean isEnabled() {
                return !Comparing.strEqual((String)TypeHierarchyBrowser.this.getCurrentViewType(), (String)TypeHierarchyBrowserBase.SUPERTYPES_HIERARCHY_TYPE);
            }
        });
    }

    @Override
    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser", "getContentDisplayName"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser", "getContentDisplayName"));
        }
        return MessageFormat.format(typeName, ClassPresentationUtil.getNameForClass((PsiClass)element, false));
    }

    @Override
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser", "getElementFromDescriptor"));
        }
        if (!(descriptor instanceof TypeHierarchyNodeDescriptor)) {
            return null;
        }
        return ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass();
    }

    @Override
    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    @Override
    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser", "isApplicableElement"));
        }
        return element instanceof PsiClass;
    }

    @Override
    protected Comparator<NodeDescriptor> getComparator() {
        return JavaHierarchyUtil.getComparator(this.myProject);
    }

    @Override
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (SUPERTYPES_HIERARCHY_TYPE.equals(typeName)) {
            return new SupertypesHierarchyTreeStructure(this.myProject, (PsiClass)psiElement);
        }
        if (SUBTYPES_HIERARCHY_TYPE.equals(typeName)) {
            return new SubtypesHierarchyTreeStructure(this.myProject, (PsiClass)psiElement, this.getCurrentScopeType());
        }
        if (TYPE_HIERARCHY_TYPE.equals(typeName)) {
            return new TypeHierarchyTreeStructure(this.myProject, (PsiClass)psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    @Override
    protected boolean canBeDeleted(PsiElement psiElement) {
        return psiElement instanceof PsiClass && !(psiElement instanceof PsiAnonymousClass);
    }

    @Override
    protected String getQualifiedName(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            return ((PsiClass)psiElement).getQualifiedName();
        }
        return "";
    }

    @Override
    @NotNull
    protected TypeHierarchyBrowserBase.BaseOnThisTypeAction createBaseOnThisAction() {
        BaseOnThisTypeAction baseOnThisTypeAction = new BaseOnThisTypeAction();
        if (baseOnThisTypeAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser", "createBaseOnThisAction"));
        }
        return baseOnThisTypeAction;
    }

    public static class BaseOnThisTypeAction
    extends TypeHierarchyBrowserBase.BaseOnThisTypeAction {
        @Override
        protected boolean isEnabled(@NotNull HierarchyBrowserBaseEx browser, @NotNull PsiElement psiElement) {
            if (browser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser$BaseOnThisTypeAction", "isEnabled"));
            }
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser$BaseOnThisTypeAction", "isEnabled"));
            }
            return super.isEnabled(browser, psiElement) && !"java.lang.Object".equals(((PsiClass)psiElement).getQualifiedName());
        }
    }
}

