/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeSafeDataProviderAdapter
implements DataProvider,
DataSink {
    private final TypeSafeDataProvider myProvider;
    private DataKey myLastKey;
    private Object myValue;

    public TypeSafeDataProviderAdapter(@NotNull TypeSafeDataProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/impl/TypeSafeDataProviderAdapter", "<init>"));
        }
        this.myLastKey = null;
        this.myValue = null;
        this.myProvider = provider;
    }

    @Nullable
    public synchronized Object getData(@NonNls String dataId) {
        this.myValue = null;
        this.myLastKey = DataKey.create((String)dataId);
        this.myProvider.calcData(this.myLastKey, (DataSink)this);
        return this.myValue;
    }

    public synchronized <T> void put(DataKey<T> key2, T data) {
        if (key2 == this.myLastKey) {
            this.myValue = data;
        }
    }

    public String toString() {
        return super.toString() + '(' + this.myProvider + ')';
    }
}

