/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.plugins.AvailablePluginsManagerMain;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstallPluginAction;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.UninstallPluginAction;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.ide.ui.search.ActionFromOptionDescriptorProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsManagerMain
extends PluginManagerMain {
    private static final String PLUGINS_PRESELECTION_PATH = "plugins.preselection.path";
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();

    public InstalledPluginsManagerMain(PluginManagerUISettings uiSettings) {
        super(uiSettings);
        this.init();
        this.myActionsPanel.setLayout(new FlowLayout(0));
        JButton installJB = new JButton("Install JetBrains plugin...");
        installJB.setMnemonic('j');
        installJB.addActionListener(new BrowseRepoListener("JetBrains"));
        this.myActionsPanel.add(installJB);
        JButton browse = new JButton("Browse repositories...");
        browse.setMnemonic('b');
        browse.addActionListener(new BrowseRepoListener(null));
        this.myActionsPanel.add(browse);
        JButton installFromDisk = new JButton("Install plugin from disk...");
        installFromDisk.setMnemonic('d');
        installFromDisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstalledPluginsTableModel model = (InstalledPluginsTableModel)InstalledPluginsManagerMain.this.pluginsModel;
                InstalledPluginsManagerMain.chooseAndInstall(model, (Consumer<Pair<File, IdeaPluginDescriptor>>)pair -> {
                    model.appendOrUpdateDescriptor((IdeaPluginDescriptor)pair.second);
                    InstalledPluginsManagerMain.this.setRequireShutdown(true);
                    InstalledPluginsManagerMain.this.select((IdeaPluginDescriptor)pair.second);
                }, InstalledPluginsManagerMain.this.myActionsPanel);
            }
        });
        this.myActionsPanel.add(installFromDisk);
        StatusText emptyText = this.pluginTable.getEmptyText();
        emptyText.setText("No plugins found. ");
        emptyText.appendText("Search in repositories", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)new BrowseRepoListener(null));
    }

    private static void chooseAndInstall(@NotNull InstalledPluginsTableModel model, @NotNull Consumer<Pair<File, IdeaPluginDescriptor>> callback, @Nullable Component parent) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/plugins/InstalledPluginsManagerMain", "chooseAndInstall"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/plugins/InstalledPluginsManagerMain", "chooseAndInstall"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, true, true, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                String extension = file2.getExtension();
                return Comparing.strEqual((String)extension, (String)"jar") || Comparing.strEqual((String)extension, (String)"zip");
            }
        };
        descriptor.setTitle("Choose Plugin File");
        descriptor.setDescription("JAR and ZIP archives are accepted");
        String oldPath = PropertiesComponent.getInstance().getValue(PLUGINS_PRESELECTION_PATH);
        VirtualFile toSelect = oldPath == null ? null : VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemDependentName((String)oldPath)), (boolean)false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, (Component)parent, (VirtualFile)toSelect, virtualFile -> {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/plugins/InstalledPluginsManagerMain", "lambda$chooseAndInstall$0"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/plugins/InstalledPluginsManagerMain", "lambda$chooseAndInstall$0"));
            }
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            PropertiesComponent.getInstance().setValue(PLUGINS_PRESELECTION_PATH, FileUtil.toSystemIndependentName((String)file2.getParent()));
            try {
                File oldFile;
                IdeaPluginDescriptorImpl pluginDescriptor = PluginDownloader.loadDescriptionFromJar(file2);
                if (pluginDescriptor == null) {
                    MessagesEx.showErrorDialog(parent, "Fail to load plugin descriptor from file " + file2.getName(), CommonBundle.getErrorTitle());
                    return;
                }
                if (ourState.wasInstalled(pluginDescriptor.getPluginId())) {
                    String message = "Plugin '" + pluginDescriptor.getName() + "' was already installed";
                    MessagesEx.showWarningDialog(parent, message, CommonBundle.getWarningTitle());
                    return;
                }
                if (PluginManagerCore.isIncompatible(pluginDescriptor)) {
                    String message = "Plugin '" + pluginDescriptor.getName() + "' is incompatible with this installation";
                    MessagesEx.showErrorDialog(parent, message, CommonBundle.getErrorTitle());
                    return;
                }
                IdeaPluginDescriptor installedPlugin = PluginManager.getPlugin(pluginDescriptor.getPluginId());
                if (installedPlugin != null && !installedPlugin.isBundled() && (oldFile = installedPlugin.getPath()) != null) {
                    StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.DeleteCommand(oldFile));
                }
                PluginInstaller.install(file2, file2.getName(), false, pluginDescriptor);
                ourState.onPluginInstall(pluginDescriptor);
                InstalledPluginsManagerMain.checkInstalledPluginDependencies(model, pluginDescriptor, parent);
                callback.consume((Object)Pair.pair((Object)file2, (Object)pluginDescriptor));
            }
            catch (IOException ex) {
                MessagesEx.showErrorDialog(parent, ex.getMessage(), CommonBundle.getErrorTitle());
            }
        });
    }

    private static void checkInstalledPluginDependencies(@NotNull InstalledPluginsTableModel model, @NotNull IdeaPluginDescriptorImpl pluginDescriptor, @Nullable Component parent) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/plugins/InstalledPluginsManagerMain", "checkInstalledPluginDependencies"));
        }
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/plugins/InstalledPluginsManagerMain", "checkInstalledPluginDependencies"));
        }
        HashSet<PluginId> notInstalled = new HashSet<PluginId>();
        HashSet<PluginId> disabledIds = new HashSet<PluginId>();
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        Object[] optionalDependentPluginIds = pluginDescriptor.getOptionalDependentPluginIds();
        for (PluginId id2 : dependentPluginIds) {
            if (ArrayUtilRt.find((Object[])optionalDependentPluginIds, (Object)id2) > -1) continue;
            boolean disabled = model.isDisabled(id2);
            boolean enabled = model.isEnabled(id2);
            if (!(enabled || disabled || PluginManagerCore.isModuleDependency(id2))) {
                notInstalled.add(id2);
                continue;
            }
            if (!disabled) continue;
            disabledIds.add(id2);
        }
        if (!notInstalled.isEmpty()) {
            String deps = StringUtil.join(notInstalled, id -> id.toString(), (String)", ");
            String message = "Plugin " + pluginDescriptor.getName() + " depends on unknown plugin" + (notInstalled.size() > 1 ? "s " : " ") + deps;
            MessagesEx.showWarningDialog(parent, message, CommonBundle.getWarningTitle());
        }
        if (!disabledIds.isEmpty()) {
            HashSet<IdeaPluginDescriptor> dependencies = new HashSet<IdeaPluginDescriptor>();
            for (IdeaPluginDescriptor ideaPluginDescriptor : model.getAllPlugins()) {
                if (!disabledIds.contains(ideaPluginDescriptor.getPluginId())) continue;
                dependencies.add(ideaPluginDescriptor);
            }
            String part = "disabled plugin" + (dependencies.size() > 1 ? "s " : " ");
            String deps = StringUtil.join(dependencies, descriptor -> descriptor.getName(), (String)", ");
            String message = "Plugin " + pluginDescriptor.getName() + " depends on " + part + deps + ". Enable " + part.trim() + "?";
            if (MessagesEx.showOkCancelDialog(parent, message, CommonBundle.getWarningTitle(), Messages.getWarningIcon()) == 0) {
                model.enableRows(dependencies.toArray(new IdeaPluginDescriptor[dependencies.size()]), Boolean.TRUE);
            }
        }
    }

    @Override
    protected void propagateUpdates(List<IdeaPluginDescriptor> list) {
    }

    private PluginManagerConfigurable createAvailableConfigurable(final String vendorFilter) {
        return new PluginManagerConfigurable(PluginManagerUISettings.getInstance(), true){

            @Override
            protected PluginManagerMain createPanel() {
                return new AvailablePluginsManagerMain(InstalledPluginsManagerMain.this, this.myUISettings, vendorFilter);
            }

            @Override
            public String getDisplayName() {
                return vendorFilter != null ? "Browse " + vendorFilter + " Plugins " : "Browse Repositories";
            }
        };
    }

    @Override
    protected JScrollPane createTable() {
        this.pluginsModel = new InstalledPluginsTableModel();
        if (PluginManagerUISettings.getInstance().installedSortByStatus) {
            this.pluginsModel.setSortByStatus(true);
        }
        this.pluginTable = new PluginTable(this.pluginsModel);
        this.pluginTable.setTableHeader(null);
        JScrollPane installedScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.pluginTable), (int)20, (int)30);
        this.pluginTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int column = InstalledPluginsTableModel.getCheckboxColumn();
                int[] selectedRows = InstalledPluginsManagerMain.this.pluginTable.getSelectedRows();
                boolean currentlyMarked = true;
                for (int selectedRow : selectedRows) {
                    if (selectedRow < 0 || !InstalledPluginsManagerMain.this.pluginTable.isCellEditable(selectedRow, column)) {
                        return;
                    }
                    Boolean enabled = (Boolean)InstalledPluginsManagerMain.this.pluginTable.getValueAt(selectedRow, column);
                    currentlyMarked &= enabled == null || enabled != false;
                }
                IdeaPluginDescriptor[] selected = new IdeaPluginDescriptor[selectedRows.length];
                int selectedLength = selected.length;
                for (int i2 = 0; i2 < selectedLength; ++i2) {
                    selected[i2] = InstalledPluginsManagerMain.this.pluginsModel.getObjectAt(InstalledPluginsManagerMain.this.pluginTable.convertRowIndexToModel(selectedRows[i2]));
                }
                ((InstalledPluginsTableModel)InstalledPluginsManagerMain.this.pluginsModel).enableRows(selected, currentlyMarked ? Boolean.FALSE : Boolean.TRUE);
                InstalledPluginsManagerMain.this.pluginTable.repaint();
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.pluginTable.setExpandableItemsEnabled(false);
        return installedScrollPane;
    }

    @Override
    protected PluginManagerMain getAvailable() {
        return this;
    }

    @Override
    protected PluginManagerMain getInstalled() {
        return this;
    }

    @Override
    protected ActionGroup getActionGroup(boolean inToolbar) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (inToolbar) {
            actionGroup.add((AnAction)new MyFilterEnabledAction());
        } else {
            actionGroup.add((AnAction)new PluginManagerMain.RefreshAction(this));
            actionGroup.addAction((AnAction)this.createSortersGroup());
            actionGroup.add((AnAction)Separator.getInstance());
            actionGroup.add((AnAction)new InstallPluginAction(this.getAvailable(), this.getInstalled()));
            actionGroup.add((AnAction)new UninstallPluginAction(this, this.pluginTable));
        }
        return actionGroup;
    }

    @Override
    public boolean isModified() {
        boolean modified = super.isModified();
        if (modified) {
            return true;
        }
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        for (int i2 = 0; i2 < this.pluginsModel.getRowCount(); ++i2) {
            if (!this.isPluginStateChanged(this.pluginsModel.getObjectAt(i2), disabledPlugins)) continue;
            return true;
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : this.pluginsModel.filtered) {
            if (!this.isPluginStateChanged(ideaPluginDescriptor, disabledPlugins)) continue;
            return true;
        }
        for (Map.Entry entry : ((InstalledPluginsTableModel)this.pluginsModel).getEnabledMap().entrySet()) {
            Boolean enabled = (Boolean)entry.getValue();
            if (enabled == null || enabled.booleanValue() || disabledPlugins.contains(((PluginId)entry.getKey()).toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isPluginStateChanged(IdeaPluginDescriptor pluginDescriptor, List<String> disabledPlugins) {
        PluginId pluginId = pluginDescriptor.getPluginId();
        boolean enabledInTable = ((InstalledPluginsTableModel)this.pluginsModel).isEnabled(pluginId);
        if (pluginDescriptor.isEnabled() != enabledInTable) {
            return !enabledInTable || disabledPlugins.contains(pluginId.getIdString());
        }
        return false;
    }

    @Override
    public String apply() {
        String apply2 = super.apply();
        if (apply2 != null) {
            return apply2;
        }
        for (int i2 = 0; i2 < this.pluginTable.getRowCount(); ++i2) {
            IdeaPluginDescriptor pluginDescriptor = this.pluginsModel.getObjectAt(i2);
            Boolean enabled = (Boolean)this.pluginsModel.getValueAt(i2, InstalledPluginsTableModel.getCheckboxColumn());
            pluginDescriptor.setEnabled(enabled != null && enabled != false);
        }
        for (IdeaPluginDescriptor descriptor : this.pluginsModel.filtered) {
            descriptor.setEnabled(((InstalledPluginsTableModel)this.pluginsModel).isEnabled(descriptor.getPluginId()));
        }
        try {
            ArrayList<String> ids = new ArrayList<String>();
            for (Map.Entry<PluginId, Boolean> entry : ((InstalledPluginsTableModel)this.pluginsModel).getEnabledMap().entrySet()) {
                Boolean value = entry.getValue();
                if (value == null || value.booleanValue()) continue;
                ids.add(entry.getKey().getIdString());
            }
            PluginManagerCore.saveDisabledPlugins(ids, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    protected String canApply() {
        HashMap<PluginId, Set<PluginId>> dependentToRequiredListMap = new HashMap<PluginId, Set<PluginId>>(((InstalledPluginsTableModel)this.pluginsModel).getDependentToRequiredListMap());
        Iterator iterator = dependentToRequiredListMap.keySet().iterator();
        while (iterator.hasNext()) {
            PluginId id = (PluginId)iterator.next();
            boolean hasNonModuleDeps = false;
            for (PluginId pluginId2 : (Set)dependentToRequiredListMap.get(id)) {
                if (PluginManagerCore.isModuleDependency(pluginId2)) continue;
                hasNonModuleDeps = true;
                break;
            }
            if (hasNonModuleDeps) continue;
            iterator.remove();
        }
        if (!dependentToRequiredListMap.isEmpty()) {
            return "<html><body style=\"padding: 5px;\">Unable to apply changes: plugin" + (dependentToRequiredListMap.size() == 1 ? " " : "s ") + StringUtil.join(dependentToRequiredListMap.keySet(), pluginId -> {
                IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin(pluginId);
                return "\"" + (ideaPluginDescriptor != null ? ideaPluginDescriptor.getName() : pluginId.getIdString()) + "\"";
            }, (String)", ") + " won't be able to load.</body></html>";
        }
        return super.canApply();
    }

    public static class PluginsActionFromOptionDescriptorProvider
    extends ActionFromOptionDescriptorProvider {
        @Nullable
        public AnAction provide(@NotNull OptionDescription description) {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/ide/plugins/InstalledPluginsManagerMain$PluginsActionFromOptionDescriptorProvider", "provide"));
            }
            String name = "Install plugin from disk...";
            if (name.equals(description.getHit()) && "preferences.pluginManager".equals(description.getConfigurableId())) {
                return new InstallFromDiskAction(name);
            }
            return null;
        }
    }

    public static class InstallFromDiskAction
    extends DumbAwareAction {
        public InstallFromDiskAction(@Nullable String text) {
            super(text, "", AllIcons.Nodes.Plugin);
        }

        public void actionPerformed(AnActionEvent e) {
            InstalledPluginsManagerMain.chooseAndInstall(new InstalledPluginsTableModel(), (Consumer<Pair<File, IdeaPluginDescriptor>>)pair -> PluginManagerConfigurable.shutdownOrRestartApp(), null);
        }
    }

    private class BrowseRepoListener
    implements ActionListener {
        private final String myVendor;

        public BrowseRepoListener(String vendor) {
            this.myVendor = vendor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final PluginManagerConfigurable configurable = InstalledPluginsManagerMain.this.createAvailableConfigurable(this.myVendor);
            SingleConfigurableEditor configurableEditor = new SingleConfigurableEditor(InstalledPluginsManagerMain.this.myActionsPanel, (Configurable)configurable, ShowSettingsUtilImpl.createDimensionKey((Configurable)configurable), false){
                {
                    super(parent, configurable2, dimensionServiceKey, showApplyButton);
                    this.setOKButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
                    this.setOKButtonMnemonic(67);
                    String filter = InstalledPluginsManagerMain.this.myFilter.getFilter();
                    if (!StringUtil.isEmptyOrSpaces((String)filter)) {
                        Runnable searchRunnable = configurable.enableSearch(filter);
                        PluginManagerMain.LOG.assertTrue(searchRunnable != null);
                        searchRunnable.run();
                    }
                }

                @Override
                @NotNull
                protected Action[] createActions() {
                    Action[] actionArray = new Action[]{this.getOKAction()};
                    if (actionArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/InstalledPluginsManagerMain$BrowseRepoListener$1", "createActions"));
                    }
                    return actionArray;
                }
            };
            configurableEditor.show();
        }
    }

    private class MyFilterEnabledAction
    extends ComboBoxAction
    implements DumbAware {
        private MyFilterEnabledAction() {
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setText(((InstalledPluginsTableModel)InstalledPluginsManagerMain.this.pluginsModel).getEnabledFilter());
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup gr = new DefaultActionGroup();
            for (final String enabledValue : InstalledPluginsTableModel.ENABLED_VALUES) {
                gr.add((AnAction)new DumbAwareAction(enabledValue){

                    public void actionPerformed(AnActionEvent e) {
                        IdeaPluginDescriptor[] selection = InstalledPluginsManagerMain.this.pluginTable.getSelectedObjects();
                        String filter = InstalledPluginsManagerMain.this.myFilter.getFilter().toLowerCase();
                        ((InstalledPluginsTableModel)InstalledPluginsManagerMain.this.pluginsModel).setEnabledFilter(enabledValue, filter);
                        if (selection != null) {
                            InstalledPluginsManagerMain.this.select(selection);
                        }
                    }
                });
            }
            DefaultActionGroup defaultActionGroup = gr;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/InstalledPluginsManagerMain$MyFilterEnabledAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            JComponent component = super.createCustomComponent(presentation);
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(false);
            panel2.add((Component)component, "Center");
            JLabel comp = new JLabel("Show:");
            comp.setIconTextGap(0);
            comp.setHorizontalTextPosition(4);
            comp.setVerticalTextPosition(0);
            comp.setAlignmentX(1.0f);
            panel2.add((Component)comp, "West");
            panel2.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)2, (int)0, (int)0));
            return panel2;
        }
    }
}

