/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectViewPsiTreeChangeListener
extends PsiTreeChangeAdapter {
    private final PsiModificationTracker myModificationTracker;
    private long myOutOfCodeBlockModificationCount;

    protected ProjectViewPsiTreeChangeListener(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/ProjectViewPsiTreeChangeListener", "<init>"));
        }
        this.myModificationTracker = PsiManager.getInstance((Project)project2).getModificationTracker();
        this.myOutOfCodeBlockModificationCount = this.myModificationTracker.getOutOfCodeBlockModificationCount();
    }

    protected abstract AbstractTreeUpdater getUpdater();

    protected abstract boolean isFlattenPackages();

    protected abstract DefaultMutableTreeNode getRootNode();

    public final void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/projectView/ProjectViewPsiTreeChangeListener", "childRemoved"));
        }
        PsiElement child = event.getOldChild();
        if (child instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/projectView/ProjectViewPsiTreeChangeListener", "childAdded"));
        }
        PsiElement child = event.getNewChild();
        if (child instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/projectView/ProjectViewPsiTreeChangeListener", "childReplaced"));
        }
        PsiElement oldChild = event.getOldChild();
        PsiElement newChild = event.getNewChild();
        if (oldChild instanceof PsiWhiteSpace && newChild instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/projectView/ProjectViewPsiTreeChangeListener", "childMoved"));
        }
        this.childrenChanged(event.getOldParent(), false);
        this.childrenChanged(event.getNewParent(), true);
    }

    public final void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/projectView/ProjectViewPsiTreeChangeListener", "childrenChanged"));
        }
        this.childrenChanged(event.getParent(), true);
    }

    protected void childrenChanged(PsiElement parent, boolean stopProcessingForThisModificationCount) {
        VirtualFile virtualFile;
        if (parent instanceof PsiDirectory && this.isFlattenPackages()) {
            this.getUpdater().addSubtreeToUpdate(this.getRootNode());
            return;
        }
        long newModificationCount = this.myModificationTracker.getOutOfCodeBlockModificationCount();
        if (newModificationCount == this.myOutOfCodeBlockModificationCount) {
            return;
        }
        if (stopProcessingForThisModificationCount) {
            this.myOutOfCodeBlockModificationCount = newModificationCount;
        }
        while (!(parent == null || parent instanceof PsiFile && (virtualFile = ((PsiFile)parent).getVirtualFile()) != null && virtualFile.getFileType() != FileTypes.PLAIN_TEXT && (parent = ((PsiFile)parent).getContainingDirectory()) == null || this.getUpdater().addSubtreeToUpdateByElement((Object)parent) || parent instanceof PsiFile || parent instanceof PsiDirectory)) {
            parent = parent.getParent();
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/projectView/ProjectViewPsiTreeChangeListener", "propertyChanged"));
        }
        String propertyName = event.getPropertyName();
        PsiElement element = event.getElement();
        DefaultMutableTreeNode rootNode = this.getRootNode();
        AbstractTreeUpdater updater = this.getUpdater();
        if (propertyName.equals("roots")) {
            updater.addSubtreeToUpdate(rootNode);
        } else if (propertyName.equals("writable")) {
            if (!updater.addSubtreeToUpdateByElement((Object)element) && element instanceof PsiFile) {
                updater.addSubtreeToUpdateByElement((Object)((PsiFile)element).getContainingDirectory());
            }
        } else if (propertyName.equals("fileName") || propertyName.equals("directoryName")) {
            if (element instanceof PsiDirectory && this.isFlattenPackages()) {
                updater.addSubtreeToUpdate(rootNode);
                return;
            }
            PsiElement parent = element.getParent();
            if (parent == null || !updater.addSubtreeToUpdateByElement((Object)parent)) {
                updater.addSubtreeToUpdateByElement((Object)element);
            }
        } else if (propertyName.equals("propFileTypes")) {
            updater.addSubtreeToUpdate(rootNode);
        }
    }
}

