/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractProjectTreeStructure
extends ProjectAbstractTreeStructureBase
implements ViewSettings {
    private final AbstractTreeNode myRoot;

    public AbstractProjectTreeStructure(Project project2) {
        super(project2);
        this.myRoot = this.createRoot(project2, this);
    }

    protected AbstractTreeNode createRoot(Project project2, ViewSettings settings) {
        return new ProjectViewProjectNode(this.myProject, this);
    }

    public abstract boolean isShowMembers();

    public final Object getRootElement() {
        return this.myRoot;
    }

    public final void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = AbstractProjectTreeStructure.asyncCommitDocuments((Project)this.myProject);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/AbstractProjectTreeStructure", "asyncCommit"));
        }
        return actionCallback;
    }

    public final boolean hasSomethingToCommit() {
        return !this.myProject.isDisposed() && PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    public boolean isStructureView() {
        return false;
    }

    public boolean isAlwaysLeaf(Object element) {
        if (element instanceof ProjectViewNode) {
            return ((ProjectViewNode)element).isAlwaysLeaf();
        }
        return super.isAlwaysLeaf(element);
    }
}

