/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Comparator;

public class GroupByTypeComparator
implements Comparator<NodeDescriptor> {
    private ProjectView myProjectView;
    private String myPaneId;
    private boolean myForceSortByType;

    public GroupByTypeComparator(ProjectView projectView, String paneId) {
        this.myProjectView = projectView;
        this.myPaneId = paneId;
    }

    public GroupByTypeComparator(boolean forceSortByType) {
        this.myForceSortByType = forceSortByType;
    }

    @Override
    public int compare(NodeDescriptor descriptor1, NodeDescriptor descriptor2) {
        Collection children2;
        if (!this.isSortByType() && descriptor1 instanceof ProjectViewNode && ((ProjectViewNode)descriptor1).isSortByFirstChild() && !(children2 = ((ProjectViewNode)descriptor1).getChildren()).isEmpty()) {
            descriptor1 = (NodeDescriptor)children2.iterator().next();
            descriptor1.update();
        }
        if (!this.isSortByType() && descriptor2 instanceof ProjectViewNode && ((ProjectViewNode)descriptor2).isSortByFirstChild() && !(children2 = ((ProjectViewNode)descriptor2).getChildren()).isEmpty()) {
            descriptor2 = (NodeDescriptor)children2.iterator().next();
            descriptor2.update();
        }
        if (descriptor1 instanceof ProjectViewNode && descriptor2 instanceof ProjectViewNode) {
            Comparable typeSortKey2;
            Comparable typeSortKey1;
            boolean isFoldersOnTop;
            Comparable key2;
            Comparable key1;
            int result2;
            Project project2 = descriptor1.getProject();
            ProjectView projectView = ProjectView.getInstance(project2);
            ProjectViewNode node1 = (ProjectViewNode)descriptor1;
            ProjectViewNode node2 = (ProjectViewNode)descriptor2;
            if (this.isManualOrder() && (result2 = GroupByTypeComparator.compare(key1 = node1.getManualOrderKey(), key2 = node2.getManualOrderKey())) != 0) {
                return result2;
            }
            boolean bl = isFoldersOnTop = !(projectView instanceof ProjectViewImpl) || ((ProjectViewImpl)projectView).isFoldersAlwaysOnTop();
            if (isFoldersOnTop) {
                int typeWeight1 = node1.getTypeSortWeight(this.isSortByType());
                int typeWeight2 = node2.getTypeSortWeight(this.isSortByType());
                if (typeWeight1 != 0 && typeWeight2 == 0) {
                    return -1;
                }
                if (typeWeight1 == 0 && typeWeight2 != 0) {
                    return 1;
                }
                if (typeWeight1 != 0 && typeWeight2 != typeWeight1) {
                    return typeWeight1 - typeWeight2;
                }
            }
            if (this.isSortByType()) {
                typeSortKey1 = node1.getTypeSortKey();
                int result3 = GroupByTypeComparator.compare(typeSortKey1, typeSortKey2 = node2.getTypeSortKey());
                if (result3 != 0) {
                    return result3;
                }
            } else {
                int result4;
                typeSortKey1 = node1.getSortKey();
                typeSortKey2 = node2.getSortKey();
                if (typeSortKey1 != null && typeSortKey2 != null && (result4 = GroupByTypeComparator.compare(typeSortKey1, typeSortKey2)) != 0) {
                    return result4;
                }
            }
            if (this.isAbbreviateQualifiedNames()) {
                String key12 = node1.getQualifiedNameSortKey();
                String key22 = node2.getQualifiedNameSortKey();
                if (key12 != null && key22 != null) {
                    return StringUtil.naturalCompare((String)key12, (String)key22);
                }
            }
        }
        if (descriptor1 == null) {
            return -1;
        }
        if (descriptor2 == null) {
            return 1;
        }
        return AlphaComparator.INSTANCE.compare(descriptor1, descriptor2);
    }

    protected boolean isManualOrder() {
        if (this.myProjectView != null) {
            return this.myProjectView.isManualOrder(this.myPaneId);
        }
        return true;
    }

    protected boolean isSortByType() {
        if (this.myProjectView != null) {
            return this.myProjectView.isSortByType(this.myPaneId);
        }
        return this.myForceSortByType;
    }

    private boolean isAbbreviateQualifiedNames() {
        return this.myProjectView != null && this.myProjectView.isAbbreviatePackageNames(this.myPaneId);
    }

    private static int compare(Comparable key1, Comparable key2) {
        if (key1 == null && key2 == null) {
            return 0;
        }
        if (key1 == null) {
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        if (key1 instanceof String && key2 instanceof String) {
            return StringUtil.naturalCompare((String)((String)((Object)key1)), (String)((String)((Object)key2)));
        }
        return key1.compareTo(key2);
    }
}

