/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewModuleNode
extends AbstractModuleNode {
    public ProjectViewModuleNode(Project project2, Module value, ViewSettings viewSettings) {
        super(project2, value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/ProjectViewModuleNode", "getChildren"));
            }
            return list;
        }
        List<VirtualFile> contentRoots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelModuleRoots(module2, this.getSettings());
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>(contentRoots.size());
        PsiManager psiManager = PsiManager.getInstance((Project)module2.getProject());
        for (VirtualFile contentRoot : contentRoots) {
            if (contentRoot.isDirectory()) {
                PsiDirectory directory = psiManager.findDirectory(contentRoot);
                if (directory == null) continue;
                children2.add((AbstractTreeNode)new PsiDirectoryNode(this.getProject(), directory, this.getSettings()));
                continue;
            }
            PsiFile file2 = psiManager.findFile(contentRoot);
            if (file2 == null) continue;
            children2.add((AbstractTreeNode)new PsiFileNode(this.getProject(), file2, this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = children2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/ProjectViewModuleNode", "getChildren"));
        }
        return arrayList;
    }

    public int getWeight() {
        return 10;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 2;
    }
}

