/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiMemberNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.Collection;

public class PsiMethodNode
extends BasePsiMemberNode<PsiMethod> {
    public PsiMethodNode(Project project2, PsiMethod value, ViewSettings viewSettings) {
        super(project2, value, viewSettings);
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        return null;
    }

    @Override
    public void updateImpl(PresentationData data) {
        String name;
        PsiMethod method2 = (PsiMethod)this.getValue();
        assert (method2 != null);
        try {
            name = PsiFormatUtil.formatMethod((PsiMethod)method2, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)2);
        }
        catch (IndexNotReadyException e) {
            name = method2.getName();
        }
        int c = name.indexOf(10);
        if (c > -1) {
            name = name.substring(0, c - 1);
        }
        data.setPresentableText(name);
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    public boolean isConstructor() {
        PsiMethod psiMethod = (PsiMethod)this.getValue();
        return psiMethod != null && psiMethod.isConstructor();
    }

    public int getWeight() {
        return this.isConstructor() ? 40 : 50;
    }

    public String getTitle() {
        PsiMethod method2 = (PsiMethod)this.getValue();
        if (method2 != null) {
            PsiClass aClass = method2.getContainingClass();
            if (aClass != null) {
                return aClass.getQualifiedName();
            }
            return method2.toString();
        }
        return super.getTitle();
    }
}

