/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleNameLocationComponent {
    private final WizardContext myWizardContext;
    private JTextField myModuleName;
    private TextFieldWithBrowseButton myModuleContentRoot;
    private TextFieldWithBrowseButton myModuleFileLocation;
    private JPanel myModulePanel;
    private boolean myModuleNameChangedByUser;
    private boolean myModuleNameDocListenerEnabled;
    private boolean myContentRootChangedByUser;
    private boolean myContentRootDocListenerEnabled;
    private boolean myImlLocationChangedByUser;
    private boolean myImlLocationDocListenerEnabled;
    private boolean myUpdatePathsWhenNameIsChanged;

    public ModuleNameLocationComponent(@NotNull WizardContext wizardContext) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/ide/projectWizard/ModuleNameLocationComponent", "<init>"));
        }
        this.myModuleNameChangedByUser = false;
        this.myModuleNameDocListenerEnabled = true;
        this.myContentRootChangedByUser = false;
        this.myContentRootDocListenerEnabled = true;
        this.myImlLocationChangedByUser = false;
        this.myImlLocationDocListenerEnabled = true;
        this.myWizardContext = wizardContext;
        this.$$$setupUI$$$();
    }

    @Nullable
    public AbstractModuleBuilder getModuleBuilder() {
        return (AbstractModuleBuilder)this.myWizardContext.getProjectBuilder();
    }

    public boolean validate() throws ConfigurationException {
        AbstractModuleBuilder builder = this.getModuleBuilder();
        if (builder != null && !builder.validateModuleName(this.getModuleName())) {
            return false;
        }
        if (!this.validateModulePaths()) {
            return false;
        }
        this.validateExistingModuleName();
        return true;
    }

    public void updateDataModel() {
        AbstractModuleBuilder moduleBuilder = this.getModuleBuilder();
        if (moduleBuilder == null) {
            return;
        }
        String moduleName = this.getModuleName();
        moduleBuilder.setName(moduleName);
        moduleBuilder.setModuleFilePath(FileUtil.toSystemIndependentName((String)this.myModuleFileLocation.getText()) + "/" + moduleName + ".iml");
        moduleBuilder.setContentEntryPath(FileUtil.toSystemIndependentName((String)this.getModuleContentRoot()));
    }

    public JPanel getModulePanel() {
        return this.myModulePanel;
    }

    public void bindModuleSettings(final NamePathComponent namePathComponent) {
        namePathComponent.getNameComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!ModuleNameLocationComponent.this.myModuleNameChangedByUser) {
                    ModuleNameLocationComponent.this.setModuleName(namePathComponent.getNameValue());
                }
            }
        });
        this.myModuleContentRoot.addBrowseFolderListener(ProjectBundle.message((String)"project.new.wizard.module.content.root.chooser.title", (Object[])new Object[0]), ProjectBundle.message((String)"project.new.wizard.module.content.root.chooser.description", (Object[])new Object[0]), this.myWizardContext.getProject(), BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
        namePathComponent.getPathComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!ModuleNameLocationComponent.this.myContentRootChangedByUser) {
                    ModuleNameLocationComponent.this.setModuleContentRoot(namePathComponent.getPath());
                }
            }
        });
        this.myModuleName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!ModuleNameLocationComponent.this.myUpdatePathsWhenNameIsChanged) {
                    return;
                }
                if (ModuleNameLocationComponent.this.myModuleNameDocListenerEnabled) {
                    ModuleNameLocationComponent.this.myModuleNameChangedByUser = true;
                }
                String path = ModuleNameLocationComponent.getDefaultBaseDir(ModuleNameLocationComponent.this.myWizardContext, namePathComponent);
                String moduleName = ModuleNameLocationComponent.this.getModuleName();
                if (path.length() > 0 && !Comparing.strEqual((String)moduleName, (String)namePathComponent.getNameValue())) {
                    path = path + "/" + moduleName;
                }
                if (!ModuleNameLocationComponent.this.myContentRootChangedByUser) {
                    boolean f = ModuleNameLocationComponent.this.myModuleNameChangedByUser;
                    ModuleNameLocationComponent.this.myModuleNameChangedByUser = true;
                    ModuleNameLocationComponent.this.setModuleContentRoot(path);
                    ModuleNameLocationComponent.this.myModuleNameChangedByUser = f;
                }
                if (!ModuleNameLocationComponent.this.myImlLocationChangedByUser) {
                    ModuleNameLocationComponent.this.setImlFileLocation(path);
                }
            }
        });
        this.myModuleContentRoot.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (ModuleNameLocationComponent.this.myContentRootDocListenerEnabled) {
                    ModuleNameLocationComponent.this.myContentRootChangedByUser = true;
                }
                if (!ModuleNameLocationComponent.this.myImlLocationChangedByUser) {
                    ModuleNameLocationComponent.this.setImlFileLocation(ModuleNameLocationComponent.this.getModuleContentRoot());
                }
                if (!ModuleNameLocationComponent.this.myModuleNameChangedByUser) {
                    String path = FileUtil.toSystemIndependentName((String)ModuleNameLocationComponent.this.getModuleContentRoot());
                    int idx = path.lastIndexOf("/");
                    boolean f = ModuleNameLocationComponent.this.myContentRootChangedByUser;
                    ModuleNameLocationComponent.this.myContentRootChangedByUser = true;
                    boolean i2 = ModuleNameLocationComponent.this.myImlLocationChangedByUser;
                    ModuleNameLocationComponent.this.myImlLocationChangedByUser = true;
                    ModuleNameLocationComponent.this.setModuleName(idx >= 0 ? path.substring(idx + 1) : "");
                    ModuleNameLocationComponent.this.myContentRootChangedByUser = f;
                    ModuleNameLocationComponent.this.myImlLocationChangedByUser = i2;
                }
            }
        });
        this.myModuleFileLocation.addBrowseFolderListener(ProjectBundle.message((String)"project.new.wizard.module.file.chooser.title", (Object[])new Object[0]), ProjectBundle.message((String)"project.new.wizard.module.file.description", (Object[])new Object[0]), this.myWizardContext.getProject(), BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
        this.myModuleFileLocation.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (ModuleNameLocationComponent.this.myImlLocationDocListenerEnabled) {
                    ModuleNameLocationComponent.this.myImlLocationChangedByUser = true;
                }
            }
        });
        namePathComponent.getPathComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!ModuleNameLocationComponent.this.myImlLocationChangedByUser) {
                    ModuleNameLocationComponent.this.setImlFileLocation(namePathComponent.getPath());
                }
            }
        });
        this.myUpdatePathsWhenNameIsChanged = true;
        if (this.myWizardContext.isCreatingNewProject()) {
            this.setModuleName(namePathComponent.getNameValue());
            this.setModuleContentRoot(namePathComponent.getPath());
            this.setImlFileLocation(namePathComponent.getPath());
        } else {
            Project project2 = this.myWizardContext.getProject();
            assert (project2 != null);
            VirtualFile baseDir = project2.getBaseDir();
            if (baseDir != null) {
                String baseDirPath = baseDir.getPath();
                String moduleName = ProjectWizardUtil.findNonExistingFileName(baseDirPath, "untitled", "");
                String contentRoot = baseDirPath + "/" + moduleName;
                if (!Comparing.strEqual((String)project2.getName(), (String)this.myWizardContext.getProjectName()) && !this.myWizardContext.isCreatingNewProject() && this.myWizardContext.getProjectName() != null) {
                    moduleName = ProjectWizardUtil.findNonExistingFileName(this.myWizardContext.getProjectFileDirectory(), this.myWizardContext.getProjectName(), "");
                    contentRoot = this.myWizardContext.getProjectFileDirectory();
                    this.myUpdatePathsWhenNameIsChanged = !this.myWizardContext.isProjectFileDirectorySetExplicitly();
                }
                this.setModuleName(moduleName);
                this.setModuleContentRoot(contentRoot);
                this.setImlFileLocation(contentRoot);
                this.myModuleName.select(0, moduleName.length());
            }
        }
    }

    private void validateExistingModuleName() throws ConfigurationException {
        Project project2 = this.myWizardContext.getProject();
        if (project2 == null) {
            return;
        }
        String moduleName = this.getModuleName();
        ProjectStructureConfigurable fromConfigurable = ProjectStructureConfigurable.getInstance(project2);
        Module module2 = fromConfigurable != null ? fromConfigurable.getModulesConfig().getModule(moduleName) : ModuleManager.getInstance((Project)project2).findModuleByName(moduleName);
        if (module2 != null) {
            throw new ConfigurationException("Module '" + moduleName + "' already exist in project. Please, specify another name.");
        }
    }

    private boolean validateModulePaths() throws ConfigurationException {
        int answer;
        String moduleName = this.getModuleName();
        String moduleFileDirectory = this.myModuleFileLocation.getText();
        if (moduleFileDirectory.length() == 0) {
            throw new ConfigurationException("Enter module file location");
        }
        if (moduleName.length() == 0) {
            throw new ConfigurationException("Enter a module name");
        }
        if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.module.file", (Object[])new Object[0]), moduleFileDirectory, this.myImlLocationChangedByUser)) {
            return false;
        }
        if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.module.content.root", (Object[])new Object[0]), this.myModuleContentRoot.getText(), this.myContentRootChangedByUser)) {
            return false;
        }
        File moduleFile = new File(moduleFileDirectory, moduleName + ".iml");
        return !moduleFile.exists() || (answer = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.overwrite.project.file", (Object[])new Object[]{moduleFile.getAbsolutePath(), IdeBundle.message((String)"project.new.wizard.module.identification", (Object[])new Object[0])}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == 0;
    }

    private String getModuleContentRoot() {
        return this.myModuleContentRoot.getText();
    }

    private static String getDefaultBaseDir(WizardContext wizardContext, NamePathComponent namePathComponent) {
        if (wizardContext.isCreatingNewProject()) {
            return namePathComponent.getPath();
        }
        Project project2 = wizardContext.getProject();
        assert (project2 != null);
        VirtualFile baseDir = project2.getBaseDir();
        if (baseDir != null) {
            return baseDir.getPath();
        }
        return "";
    }

    private void setImlFileLocation(String path) {
        this.myImlLocationDocListenerEnabled = false;
        this.myModuleFileLocation.setText(FileUtil.toSystemDependentName((String)path));
        this.myImlLocationDocListenerEnabled = true;
    }

    private void setModuleContentRoot(String path) {
        this.myContentRootDocListenerEnabled = false;
        this.myModuleContentRoot.setText(FileUtil.toSystemDependentName((String)path));
        this.myContentRootDocListenerEnabled = true;
    }

    public void setModuleName(String moduleName) {
        this.myModuleNameDocListenerEnabled = false;
        this.myModuleName.setText(moduleName);
        this.myModuleNameDocListenerEnabled = true;
    }

    public JTextField getModuleNameField() {
        return this.myModuleName;
    }

    private String getModuleName() {
        return this.myModuleName.getText().trim();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JTextField jTextField;
        JPanel jPanel;
        this.myModulePanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.module.name.title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.myModuleName = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jTextField, gridBagConstraints2);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.module.root.title"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 17;
        jPanel.add((Component)jLabel2, gridBagConstraints3);
        this.myModuleContentRoot = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)textFieldWithBrowseButton2, gridBagConstraints4);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.module.file.title"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.anchor = 17;
        jPanel.add((Component)jLabel3, gridBagConstraints5);
        this.myModuleFileLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)textFieldWithBrowseButton, gridBagConstraints6);
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myModulePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

