/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.ide.scopeView.ScopePaneSelectInTarget;
import com.intellij.ide.scopeView.ScopeTreeViewPanel;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ScopeViewPane
extends AbstractProjectViewPane {
    @NonNls
    public static final String ID = "Scope";
    private ScopeTreeViewPanel myViewPanel;
    private final DependencyValidationManager myDependencyValidationManager;
    private final NamedScopeManager myNamedScopeManager;
    private final NamedScopesHolder.ScopeListener myScopeListener;

    public ScopeViewPane(@NotNull Project project2, DependencyValidationManager dependencyValidationManager, NamedScopeManager namedScopeManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scopeView/ScopeViewPane", "<init>"));
        }
        super(project2);
        this.myDependencyValidationManager = dependencyValidationManager;
        this.myNamedScopeManager = namedScopeManager;
        this.myScopeListener = new NamedScopesHolder.ScopeListener(){
            final Alarm refreshProjectViewAlarm;
            {
                this.refreshProjectViewAlarm = new Alarm((Disposable)ScopeViewPane.this.myProject);
            }

            public void scopesChanged() {
                if (this.refreshProjectViewAlarm.isDisposed()) {
                    return;
                }
                this.refreshProjectViewAlarm.cancelAllRequests();
                this.refreshProjectViewAlarm.addRequest(() -> {
                    if (ScopeViewPane.this.myProject.isDisposed()) {
                        return;
                    }
                    String subId = ScopeViewPane.this.getSubId();
                    ProjectView projectView = ProjectView.getInstance(ScopeViewPane.this.myProject);
                    String id = projectView.getCurrentViewId();
                    projectView.removeProjectPane(ScopeViewPane.this);
                    projectView.addProjectPane(ScopeViewPane.this);
                    if (id != null) {
                        if (Comparing.strEqual((String)id, (String)ScopeViewPane.this.getId())) {
                            projectView.changeView(id, subId);
                        } else {
                            projectView.changeView(id);
                        }
                    }
                }, 10);
            }
        };
        this.myDependencyValidationManager.addScopeListener(this.myScopeListener);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"scope.view.title", (Object[])new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Ide.LocalScope;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "getId"));
        }
        return ID;
    }

    @Override
    public JComponent createComponent() {
        if (this.myViewPanel == null) {
            this.myViewPanel = new ScopeTreeViewPanel(this.myProject);
            Disposer.register((Disposable)this, (Disposable)this.myViewPanel);
            this.myViewPanel.initListeners();
            this.myTree = this.myViewPanel.getTree();
            CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "ScopeViewPopupMenu", "ScopeViewPopup");
            this.enableDnD();
        }
        this.myViewPanel.selectScope(NamedScopesHolder.getScope((Project)this.myProject, (String)this.getSubId()));
        return this.myViewPanel.getPanel();
    }

    @Override
    public void dispose() {
        this.myViewPanel = null;
        this.myDependencyValidationManager.removeScopeListener(this.myScopeListener);
        this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
        super.dispose();
    }

    @Override
    @NotNull
    public String[] getSubIds() {
        String[] stringArray = (String[])ContainerUtil.map2Array(this.getShownScopes(), String.class, scope -> scope.getName());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "getSubIds"));
        }
        return stringArray;
    }

    @NotNull
    public static Collection<NamedScope> getShownScopes(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scopeView/ScopeViewPane", "getShownScopes"));
        }
        Collection<NamedScope> collection = ScopeViewPane.getShownScopes(DependencyValidationManager.getInstance((Project)project2), NamedScopeManager.getInstance((Project)project2));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "getShownScopes"));
        }
        return collection;
    }

    private Collection<NamedScope> getShownScopes() {
        return ScopeViewPane.getShownScopes(this.myDependencyValidationManager, this.myNamedScopeManager);
    }

    @NotNull
    private static Collection<NamedScope> getShownScopes(DependencyValidationManager dependencyValidationManager, NamedScopeManager namedScopeManager) {
        ArrayList list = ContainerUtil.newArrayList();
        for (NamedScope scope : ContainerUtil.concat((Object[][])new NamedScope[][]{dependencyValidationManager.getScopes(), namedScopeManager.getScopes()})) {
            if (scope instanceof NonProjectFilesScope || scope == CustomScopesProviderEx.getAllScope()) continue;
            list.add(scope);
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "getShownScopes"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        if (subId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subId", "com/intellij/ide/scopeView/ScopeViewPane", "getPresentableSubIdName"));
        }
        String string = subId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "getPresentableSubIdName"));
        }
        return string;
    }

    @Override
    public void addToolbarActions(DefaultActionGroup actionGroup) {
        actionGroup.add(ActionManager.getInstance().getAction("ScopeView.EditScopes"));
        actionGroup.addAction((AnAction)new ShowModulesAction(this.myProject){

            @Override
            @NotNull
            protected String getId() {
                String string = ScopeViewPane.this.getId();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane$2", "getId"));
                }
                return string;
            }
        }).setAsSecondary(true);
    }

    @Override
    @NotNull
    public ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        this.saveExpandedPaths();
        this.myViewPanel.selectScope(NamedScopesHolder.getScope((Project)this.myProject, (String)this.getSubId()));
        this.restoreExpandedPaths();
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "updateFromRoot"));
        }
        return actionCallback;
    }

    @Override
    public void select(Object element, VirtualFile file2, boolean requestFocus) {
        String name;
        PsiDirectory psiFile;
        if (file2 == null) {
            return;
        }
        Object object = psiFile = file2.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(file2) : PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return;
        }
        if (!(element instanceof PsiElement)) {
            return;
        }
        ArrayList allScopes = ContainerUtil.newArrayList(this.getShownScopes());
        for (NamedScope scope : allScopes) {
            name = scope.getName();
            if (!name.equals(this.getSubId())) continue;
            allScopes.remove(scope);
            allScopes.add(0, scope);
            break;
        }
        for (NamedScope scope : allScopes) {
            name = scope.getName();
            PackageSet packageSet = scope.getValue();
            if (packageSet == null || !this.changeView(packageSet, (PsiElement)element, (PsiFileSystemItem)psiFile, name, (NamedScopesHolder)this.myNamedScopeManager, requestFocus) && !this.changeView(packageSet, (PsiElement)element, (PsiFileSystemItem)psiFile, name, (NamedScopesHolder)this.myDependencyValidationManager, requestFocus)) continue;
            break;
        }
    }

    private boolean changeView(PackageSet packageSet, PsiElement element, PsiFileSystemItem psiFileSystemItem, String name, NamedScopesHolder holder, boolean requestFocus) {
        if (packageSet instanceof PackageSetBase && ((PackageSetBase)packageSet).contains(psiFileSystemItem.getVirtualFile(), this.myProject, holder) || psiFileSystemItem instanceof PsiFile && packageSet.contains((PsiFile)psiFileSystemItem, holder)) {
            if (!name.equals(this.getSubId())) {
                if (!requestFocus) {
                    return true;
                }
                ProjectView.getInstance(this.myProject).changeView(this.getId(), name);
            }
            this.myViewPanel.selectNode(element, psiFileSystemItem, requestFocus);
            return true;
        }
        return false;
    }

    @Override
    public int getWeight() {
        return 3;
    }

    @Override
    public void installComparator() {
        this.myViewPanel.setSortByType();
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ScopePaneSelectInTarget(this.myProject);
    }

    @Override
    protected Object exhumeElementFromNode(DefaultMutableTreeNode node) {
        if (node instanceof PackageDependenciesNode) {
            return ((PackageDependenciesNode)node).getPsiElement();
        }
        return super.exhumeElementFromNode(node);
    }

    @Override
    public Object getData(String dataId) {
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        return this.myViewPanel == null ? null : this.myViewPanel.getData(dataId);
    }

    @Override
    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/scopeView/ScopeViewPane", "getReady"));
        }
        ActionCallback callback = this.myViewPanel.getActionCallback();
        ActionCallback actionCallback = callback == null ? ActionCallback.DONE : callback;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "getReady"));
        }
        return actionCallback;
    }
}

