/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.customRegions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRegionTreeElement
implements StructureViewTreeElement {
    private final PsiElement myStartElement;
    private int myEndOffset;
    private Collection<StructureViewTreeElement> myChildElements;
    private final CustomFoldingProvider myProvider;
    private CustomRegionTreeElement myParent;
    private List<CustomRegionTreeElement> mySubRegions;

    public CustomRegionTreeElement(@NotNull PsiElement startElement, @NotNull CustomFoldingProvider provider, @Nullable CustomRegionTreeElement parent) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement", "<init>"));
        }
        this.myEndOffset = Integer.MAX_VALUE;
        this.myChildElements = new ArrayList<StructureViewTreeElement>();
        this.myStartElement = startElement;
        this.myProvider = provider;
        this.myParent = parent;
    }

    public CustomRegionTreeElement(@NotNull PsiElement startElement, @NotNull CustomFoldingProvider provider) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement", "<init>"));
        }
        this(startElement, provider, null);
    }

    public Object getValue() {
        return this;
    }

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.myStartElement).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myStartElement instanceof Navigatable && ((Navigatable)this.myStartElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return CustomRegionTreeElement.this.myProvider.getPlaceholderText(CustomRegionTreeElement.this.myStartElement.getText());
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Nodes.CustomRegion;
            }
        };
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement", "getPresentation"));
        }
        return itemPresentation;
    }

    public void addChild(@NotNull StructureViewTreeElement childElement) {
        if (childElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childElement", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement", "addChild"));
        }
        if (this.mySubRegions != null) {
            for (CustomRegionTreeElement subRegion : this.mySubRegions) {
                if (!subRegion.containsElement(childElement)) continue;
                subRegion.addChild(childElement);
                return;
            }
        }
        this.myChildElements.add(childElement);
    }

    @NotNull
    public TreeElement[] getChildren() {
        if (this.mySubRegions == null || this.mySubRegions.isEmpty()) {
            TreeElement[] treeElementArray = (TreeElement[])this.myChildElements.toArray(new StructureViewTreeElement[this.myChildElements.size()]);
            if (treeElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement", "getChildren"));
            }
            return treeElementArray;
        }
        StructureViewTreeElement[] allElements = new StructureViewTreeElement[this.myChildElements.size() + this.mySubRegions.size()];
        int index = 0;
        for (StructureViewTreeElement structureViewTreeElement : this.myChildElements) {
            allElements[index++] = structureViewTreeElement;
        }
        for (StructureViewTreeElement structureViewTreeElement : this.mySubRegions) {
            allElements[index++] = structureViewTreeElement;
        }
        if (allElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement", "getChildren"));
        }
        return allElements;
    }

    public boolean containsElement(StructureViewTreeElement element) {
        TextRange elementRange;
        Object o = element.getValue();
        return o instanceof PsiElement && (elementRange = ((PsiElement)o).getTextRange()).getStartOffset() >= this.myStartElement.getTextRange().getStartOffset() && elementRange.getEndOffset() <= this.myEndOffset;
    }

    public CustomRegionTreeElement createNestedRegion(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement", "createNestedRegion"));
        }
        if (this.mySubRegions == null) {
            this.mySubRegions = new ArrayList<CustomRegionTreeElement>();
        }
        CustomRegionTreeElement currSubRegion = new CustomRegionTreeElement(element, this.myProvider, this);
        this.mySubRegions.add(currSubRegion);
        return currSubRegion;
    }

    public CustomRegionTreeElement endRegion(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement", "endRegion"));
        }
        this.myEndOffset = element.getTextRange().getEndOffset();
        return this.myParent;
    }

    public String toString() {
        return "Region '" + this.myProvider.getPlaceholderText(this.myStartElement.getText()) + "'";
    }
}

