/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class MacIntelliJTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public MacIntelliJTextFieldUI(JTextField textField) {
        super(textField);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJTextFieldUI((JTextField)c);
    }

    @Override
    public void showSearchPopup() {
        Object value = this.myTextField.getClientProperty("JTextField.Search.FindPopup");
        JTextComponent editor = this.getComponent();
        if (editor != null && value instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)value;
            popup.show(editor, this.getSearchIconCoord().x, editor.getHeight());
        }
    }

    @Override
    public String getToolTipText(JTextComponent t, Point pt) {
        AbstractAction action;
        if (this.getActionUnder(pt) == TextFieldWithPopupHandlerUI.SearchAction.NEWLINE && (action = MacIntelliJTextFieldUI.getNewLineAction(t)) != null) {
            return (String)action.getValue("ShortDescription");
        }
        return super.getToolTipText(t, pt);
    }

    @Override
    public TextFieldWithPopupHandlerUI.SearchAction getActionUnder(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/ide/ui/laf/intellij/MacIntelliJTextFieldUI", "getActionUnder"));
        }
        int off = JBUI.scale((int)8);
        Point point = new Point(p.x - off, p.y - off);
        if (point.distance(this.getSearchIconCoord()) <= (double)off) {
            return TextFieldWithPopupHandlerUI.SearchAction.POPUP;
        }
        if (this.hasText() && point.distance(this.getClearIconCoord()) <= (double)off) {
            return TextFieldWithPopupHandlerUI.SearchAction.CLEAR;
        }
        if (MacIntelliJTextFieldUI.getNewLineAction(this.myTextField) != null && point.distance(this.getAddNewLineIconCoord()) <= (double)off) {
            return TextFieldWithPopupHandlerUI.SearchAction.NEWLINE;
        }
        return null;
    }

    protected Rectangle getDrawingRect() {
        return new Rectangle(0, (this.myTextField.getHeight() - 26) / 2, this.myTextField.getWidth(), this.myTextField.getHeight());
    }

    Icon getSearchIcon(Component c) {
        return MacIntelliJIconCache.getIcon(MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c) ? "searchFieldWithHistory" : "searchFieldLabel");
    }

    protected Point getSearchIconCoord() {
        Rectangle r = this.getDrawingRect();
        Icon icon = this.getSearchIcon(this.myTextField);
        return new Point(r.x + (this.hasText() || this.myTextField.hasFocus() || MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(this.myTextField) ? JBUI.scale((int)8) : (r.width - icon.getIconWidth()) / 2), r.y + (r.height - icon.getIconHeight()) / 2 + JBUI.scale((int)1));
    }

    protected Point getClearIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + r.width - JBUI.scale((int)16) - JBUI.scale((int)6), r.y + (r.height - JBUI.scale((int)16)) / 2);
    }

    protected Point getAddNewLineIconCoord() {
        Point point = this.getClearIconCoord();
        if (!StringUtil.isEmpty((String)this.myTextField.getText())) {
            point.x -= JBUI.scale((int)16) + JBUI.scale((int)8);
        }
        return point;
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        Rectangle r = this.getDrawingRect();
        if (c.isOpaque() && parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (MacIntelliJTextFieldUI.isSearchField(c)) {
            this.paintSearchField(g, c, r);
        } else if (c.getBorder() instanceof MacIntelliJTextBorder) {
            g.setColor(c.getBackground());
            g.fillRect(3, 3, c.getWidth() - 6, c.getHeight() - 6);
        } else {
            super.paintBackground(g);
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        Dimension dimension = new Dimension(size.width + this.getIconsWidth(c), Math.max(26, size.height));
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/intellij/MacIntelliJTextFieldUI", "getPreferredSize"));
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension minimumSize = super.getMinimumSize(c);
        return new Dimension(minimumSize.width + this.getIconsWidth(c), minimumSize.height);
    }

    private int getIconsWidth(JComponent c) {
        int width = 0;
        if (MacIntelliJTextFieldUI.isSearchField(c)) {
            Icon label = this.getSearchIcon(c);
            width += label.getIconWidth();
            if (this.hasText()) {
                Icon clearIcon = MacIntelliJIconCache.getIcon("searchFieldClear");
                width += clearIcon.getIconWidth() + 3;
            }
        }
        return width;
    }

    protected void paintSearchField(Graphics2D g, JTextComponent c, Rectangle r) {
        Icon newLineIcon;
        AbstractAction newLineAction;
        boolean noBorder = c.getClientProperty("JTextField.Search.noBorderRing") == Boolean.TRUE;
        boolean hasFocus = c.hasFocus() && !noBorder;
        Icon left = MacIntelliJIconCache.getIcon("searchFieldLeft", false, hasFocus);
        Icon middle = MacIntelliJIconCache.getIcon("searchFieldMiddle", false, hasFocus);
        Icon right = MacIntelliJIconCache.getIcon("searchFieldRight", false, hasFocus);
        Graphics gg = g.create(0, 0, c.getWidth(), c.getHeight());
        gg.setClip(r.x, r.y, r.width - right.getIconWidth(), r.height);
        int x = r.x;
        int stop2 = r.x + (r.width - right.getIconWidth());
        left.paintIcon(c, g, r.x, r.y);
        x += left.getIconWidth();
        while (x < stop2) {
            middle.paintIcon(c, gg, x, r.y);
            x += middle.getIconWidth();
        }
        gg.dispose();
        right.paintIcon(c, g, stop2, r.y);
        boolean withHistoryPopup = MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c);
        Icon label = this.getSearchIcon(c);
        boolean isEmpty = !this.hasText();
        Point point = this.getSearchIconCoord();
        if (isEmpty && !c.hasFocus() && !withHistoryPopup) {
            label.paintIcon(c, g, point.x, point.y);
        } else {
            gg = g.create(0, 0, c.getWidth(), c.getHeight());
            gg.setClip(point.x, point.y, isEmpty ? label.getIconWidth() : 16, label.getIconHeight());
            label.paintIcon(c, gg, point.x, point.y);
        }
        Icon clearIcon = MacIntelliJIconCache.getIcon("searchFieldClear");
        if (!isEmpty) {
            clearIcon.paintIcon(c, g, this.getClearIconCoord().x, r.y);
        }
        if ((newLineAction = MacIntelliJTextFieldUI.getNewLineAction(c)) != null && (newLineIcon = (Icon)newLineAction.getValue("SmallIcon")) != null) {
            newLineIcon.paintIcon(c, g, this.getAddNewLineIconCoord().x, r.y);
        }
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rect = super.getVisibleEditorRect();
        if (rect != null) {
            if (MacIntelliJTextFieldUI.isSearchField(this.myTextField)) {
                int extraOffset = MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(this.myTextField) ? 3 : 0;
                rect.width -= 36 + extraOffset;
                if (MacIntelliJTextFieldUI.getNewLineAction(this.myTextField) != null) {
                    rect.width -= 24;
                }
                rect.x += 19 + extraOffset;
                ++rect.y;
            } else {
                rect.x += 2;
                rect.width -= 4;
            }
        }
        return rect;
    }

    @Override
    protected void paintSafely(Graphics g) {
        this.paintBackground(g);
        super.paintSafely(g);
    }

    public static void paintAquaSearchFocusRing(Graphics2D g, Rectangle r, Component c) {
        g = (Graphics2D)g.create(0, 0, r.width, r.height);
        GraphicsUtil.setupAAPainting((Graphics)g);
        g.setColor(c.getBackground());
        RoundRectangle2D.Double border = MacIntelliJTextFieldUI.getShape(r, 4.0, true);
        g.fill(border);
        g.setColor((Color)Gray._192);
        g.setStroke(new BasicStroke(0.5f));
        g.draw(MacIntelliJTextFieldUI.getShape(r, 4.0, false));
        if (c.hasFocus()) {
            Color graphiteColor = new Color(7303026);
            Color blueColor = ColorUtil.brighter((Color)new Color(28130), (int)3);
            g.setColor(ColorUtil.withAlpha((Color)(IntelliJLaf.isGraphite() ? graphiteColor : blueColor), (double)0.35));
            Area area = new Area(MacIntelliJTextFieldUI.getShape(r, 7.0, false));
            area.subtract(new Area(MacIntelliJTextFieldUI.getShape(r, 3.5, true)));
            g.fill(area);
        }
        g.dispose();
    }

    private static RoundRectangle2D.Double getShape(Rectangle r, double radius, boolean inner) {
        double max_radius = 6.0;
        radius = Math.min(max_radius, Math.max(0.0, radius));
        double inset = max_radius - radius;
        double indent = inner ? 0.5 : 0.0;
        return new RoundRectangle2D.Double((double)r.x + inset + indent, (double)r.y + inset + indent, (double)r.width - 2.0 * inset - indent, (double)r.height - 2.0 * inset - indent, 2.0 * radius, 2.0 * radius);
    }
}

